/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.application;

import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.eclipse.milo.opcua.stack.core.channel.ChannelConfig;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.ApplicationDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;

public interface UaStackClient {
    public CompletableFuture<UaStackClient> connect();

    public CompletableFuture<UaStackClient> disconnect();

    public <T extends UaResponseMessage> CompletableFuture<T> sendRequest(UaRequestMessage var1);

    public void sendRequests(List<? extends UaRequestMessage> var1, List<CompletableFuture<? extends UaResponseMessage>> var2);

    public ApplicationDescription getApplication();

    public Optional<KeyPair> getKeyPair();

    public Optional<X509Certificate> getCertificate();

    public String getEndpointUrl();

    public Optional<EndpointDescription> getEndpoint();

    public ChannelConfig getChannelConfig();

    public UInteger getChannelLifetime();

    public ExecutorService getExecutorService();
}

