/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.application.services;

import com.google.common.base.MoreObjects;
import io.netty.util.DefaultAttributeMap;
import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.application.UaStackServer;
import org.eclipse.milo.opcua.stack.core.channel.ServerSecureChannel;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.ServiceFault;

public class ServiceRequest<ReqT extends UaRequestMessage, ResT extends UaResponseMessage>
extends DefaultAttributeMap {
    private final CompletableFuture<ResT> future = new CompletableFuture();
    private final ReqT request;
    private final long requestId;
    private final UaStackServer server;
    private final ServerSecureChannel secureChannel;

    public ServiceRequest(ReqT request, long requestId, UaStackServer server, ServerSecureChannel secureChannel) {
        this.request = request;
        this.requestId = requestId;
        this.server = server;
        this.secureChannel = secureChannel;
    }

    public CompletableFuture<ResT> getFuture() {
        return this.future;
    }

    public ReqT getRequest() {
        return this.request;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public UaStackServer getServer() {
        return this.server;
    }

    public ServerSecureChannel getSecureChannel() {
        return this.secureChannel;
    }

    public void setResponse(ResT response) {
        this.future.complete(response);
    }

    public void setServiceFault(UaException exception) {
        this.future.completeExceptionally(exception);
    }

    public void setServiceFault(long statusCode) {
        this.setServiceFault(new StatusCode(statusCode));
    }

    public void setServiceFault(StatusCode statusCode) {
        this.future.completeExceptionally(new UaException(statusCode, "ServiceFault"));
    }

    public ResponseHeader createResponseHeader() {
        return this.createResponseHeader(StatusCode.GOOD);
    }

    public ResponseHeader createResponseHeader(long statusCode) {
        return this.createResponseHeader(new StatusCode(statusCode));
    }

    public ResponseHeader createResponseHeader(StatusCode serviceResult) {
        return new ResponseHeader(DateTime.now(), this.request.getRequestHeader().getRequestHandle(), serviceResult, null, null, null);
    }

    public ServiceFault createServiceFault(long statusCode) {
        ResponseHeader responseHeader = new ResponseHeader(DateTime.now(), this.request.getRequestHeader().getRequestHandle(), new StatusCode(statusCode), null, null, null);
        return new ServiceFault(responseHeader);
    }

    public ServiceFault createServiceFault(Throwable throwable) {
        UaException exception = throwable instanceof UaException ? (UaException)throwable : new UaException(throwable);
        ResponseHeader responseHeader = new ResponseHeader(DateTime.now(), this.request.getRequestHeader().getRequestHandle(), exception.getStatusCode(), null, null, null);
        return new ServiceFault(responseHeader);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("requestId", this.requestId).add("request", (Object)this.request.getClass().getSimpleName()).toString();
    }
}

