/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.application.services;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.types.structured.ServiceFault;

public class ServiceResponse {
    private final UaRequestMessage request;
    private final UaResponseMessage response;
    private final long requestId;
    private final boolean serviceFault;

    public ServiceResponse(UaRequestMessage request, long requestId, UaResponseMessage response) {
        this.request = request;
        this.requestId = requestId;
        this.response = response;
        this.serviceFault = false;
    }

    public ServiceResponse(UaRequestMessage request, long requestId, ServiceFault serviceFault) {
        this.request = request;
        this.requestId = requestId;
        this.response = serviceFault;
        this.serviceFault = true;
    }

    public UaRequestMessage getRequest() {
        return this.request;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public UaResponseMessage getResponse() {
        return this.response;
    }

    public boolean isServiceFault() {
        return this.serviceFault;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this).add("requestId", this.requestId).add("request", (Object)this.request.getClass().getSimpleName()).add("response", (Object)this.response.getClass().getSimpleName());
        if (this.serviceFault) {
            helper.add("result", (Object)this.response.getResponseHeader().getServiceResult());
        }
        return helper.toString();
    }
}

