/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.channel.messages;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import org.eclipse.milo.opcua.stack.core.util.annotations.UInt32Primitive;

public class AcknowledgeMessage {
    @UInt32Primitive
    private final long protocolVersion;
    @UInt32Primitive
    private final long receiveBufferSize;
    @UInt32Primitive
    private final long sendBufferSize;
    @UInt32Primitive
    private final long maxMessageSize;
    @UInt32Primitive
    private final long maxChunkCount;

    public AcknowledgeMessage(@UInt32Primitive long protocolVersion, @UInt32Primitive long receiveBufferSize, @UInt32Primitive long sendBufferSize, @UInt32Primitive long maxMessageSize, @UInt32Primitive long maxChunkCount) {
        Preconditions.checkArgument((receiveBufferSize >= 8192L ? 1 : 0) != 0, (Object)"receiverBufferSize must be greater than or equal to 8192");
        Preconditions.checkArgument((sendBufferSize >= 8192L ? 1 : 0) != 0, (Object)"sendBufferSize must be greater than or equal to 8192");
        this.protocolVersion = protocolVersion;
        this.receiveBufferSize = receiveBufferSize;
        this.sendBufferSize = sendBufferSize;
        this.maxMessageSize = maxMessageSize;
        this.maxChunkCount = maxChunkCount;
    }

    @UInt32Primitive
    public long getProtocolVersion() {
        return this.protocolVersion;
    }

    @UInt32Primitive
    public long getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    @UInt32Primitive
    public long getSendBufferSize() {
        return this.sendBufferSize;
    }

    @UInt32Primitive
    public long getMaxMessageSize() {
        return this.maxMessageSize;
    }

    @UInt32Primitive
    public long getMaxChunkCount() {
        return this.maxChunkCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AcknowledgeMessage that = (AcknowledgeMessage)o;
        return this.maxChunkCount == that.maxChunkCount && this.maxMessageSize == that.maxMessageSize && this.protocolVersion == that.protocolVersion && this.receiveBufferSize == that.receiveBufferSize && this.sendBufferSize == that.sendBufferSize;
    }

    public int hashCode() {
        int result = (int)(this.protocolVersion ^ this.protocolVersion >>> 32);
        result = 31 * result + (int)(this.receiveBufferSize ^ this.receiveBufferSize >>> 32);
        result = 31 * result + (int)(this.sendBufferSize ^ this.sendBufferSize >>> 32);
        result = 31 * result + (int)(this.maxMessageSize ^ this.maxMessageSize >>> 32);
        result = 31 * result + (int)(this.maxChunkCount ^ this.maxChunkCount >>> 32);
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("protocolVersion", this.protocolVersion).add("receiverBufferSize", this.receiveBufferSize).add("sendBufferSize", this.sendBufferSize).add("maxMessageSize", this.maxMessageSize).add("maxChunkCount", this.maxChunkCount).toString();
    }

    public static void encode(AcknowledgeMessage message, ByteBuf buffer) {
        buffer.writeInt((int)message.getProtocolVersion());
        buffer.writeInt((int)message.getReceiveBufferSize());
        buffer.writeInt((int)message.getSendBufferSize());
        buffer.writeInt((int)message.getMaxMessageSize());
        buffer.writeInt((int)message.getMaxChunkCount());
    }

    public static AcknowledgeMessage decode(ByteBuf buffer) {
        return new AcknowledgeMessage(buffer.readUnsignedInt(), buffer.readUnsignedInt(), buffer.readUnsignedInt(), buffer.readUnsignedInt(), buffer.readUnsignedInt());
    }
}

