/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.channel.messages;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import org.eclipse.milo.opcua.stack.core.serialization.OpcUaBinaryStreamDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.OpcUaBinaryStreamEncoder;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;

public class ErrorMessage {
    private final StatusCode error;
    private final String reason;

    public ErrorMessage(long error, String reason) {
        this.error = new StatusCode(error);
        this.reason = reason;
    }

    public StatusCode getError() {
        return this.error;
    }

    public String getReason() {
        return this.reason;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("error", (Object)this.error).add("reason", (Object)this.reason).toString();
    }

    public static void encode(ErrorMessage message, ByteBuf buffer) {
        buffer.writeInt((int)message.getError().getValue());
        ErrorMessage.encodeString(message.getReason(), buffer);
    }

    public static ErrorMessage decode(ByteBuf buffer) {
        return new ErrorMessage(buffer.readUnsignedInt(), ErrorMessage.decodeString(buffer));
    }

    private static void encodeString(String s, ByteBuf buffer) {
        new OpcUaBinaryStreamEncoder(buffer).writeString(s);
    }

    private static String decodeString(ByteBuf buffer) {
        return new OpcUaBinaryStreamDecoder(buffer).readString();
    }
}

