/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.security;

import java.util.Optional;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.security.SecurityAlgorithm;

public enum SecurityPolicy {
    None("http://opcfoundation.org/UA/SecurityPolicy#None", SecurityAlgorithm.None, SecurityAlgorithm.None, SecurityAlgorithm.None, SecurityAlgorithm.None, SecurityAlgorithm.None, SecurityAlgorithm.None, SecurityAlgorithm.None),
    Basic128Rsa15("http://opcfoundation.org/UA/SecurityPolicy#Basic128Rsa15", SecurityAlgorithm.HmacSha1, SecurityAlgorithm.Aes128, SecurityAlgorithm.RsaSha1, SecurityAlgorithm.Rsa15, SecurityAlgorithm.KwRsa15, SecurityAlgorithm.PSha1, SecurityAlgorithm.Sha1),
    Basic256("http://opcfoundation.org/UA/SecurityPolicy#Basic256", SecurityAlgorithm.HmacSha1, SecurityAlgorithm.Aes256, SecurityAlgorithm.RsaSha1, SecurityAlgorithm.RsaOaepSha1, SecurityAlgorithm.KwRsaOaep, SecurityAlgorithm.PSha1, SecurityAlgorithm.Sha1),
    Basic256Sha256("http://opcfoundation.org/UA/SecurityPolicy#Basic256Sha256", SecurityAlgorithm.HmacSha256, SecurityAlgorithm.Aes256, SecurityAlgorithm.RsaSha256, SecurityAlgorithm.RsaOaepSha1, SecurityAlgorithm.KwRsaOaep, SecurityAlgorithm.PSha256, SecurityAlgorithm.Sha256),
    Aes128_Sha256_RsaOaep("http://opcfoundation.org/UA/SecurityPolicy#Aes128_Sha256_RsaOaep", SecurityAlgorithm.HmacSha256, SecurityAlgorithm.Aes128, SecurityAlgorithm.RsaSha256, SecurityAlgorithm.RsaOaepSha1, null, SecurityAlgorithm.PSha256, SecurityAlgorithm.Sha256),
    Aes256_Sha256_RsaPss("http://opcfoundation.org/UA/SecurityPolicy#Aes256_Sha256_RsaPss", SecurityAlgorithm.HmacSha256, SecurityAlgorithm.Aes256, SecurityAlgorithm.RsaSha256Pss, SecurityAlgorithm.RsaOaepSha256, null, SecurityAlgorithm.PSha256, SecurityAlgorithm.Sha256);

    private final String securityPolicyUri;
    private final SecurityAlgorithm symmetricSignatureAlgorithm;
    private final SecurityAlgorithm symmetricEncryptionAlgorithm;
    private final SecurityAlgorithm asymmetricSignatureAlgorithm;
    private final SecurityAlgorithm asymmetricEncryptionAlgorithm;
    private final SecurityAlgorithm asymmetricKeyWrapAlgorithm;
    private final SecurityAlgorithm keyDerivationAlgorithm;
    private final SecurityAlgorithm certificateSignatureAlgorithm;

    private SecurityPolicy(String securityPolicyUri, SecurityAlgorithm symmetricSignatureAlgorithm, SecurityAlgorithm symmetricEncryptionAlgorithm, SecurityAlgorithm asymmetricSignatureAlgorithm, SecurityAlgorithm asymmetricEncryptionAlgorithm, SecurityAlgorithm asymmetricKeyWrapAlgorithm, SecurityAlgorithm keyDerivationAlgorithm, SecurityAlgorithm certificateSignatureAlgorithm) {
        this.securityPolicyUri = securityPolicyUri;
        this.symmetricSignatureAlgorithm = symmetricSignatureAlgorithm;
        this.symmetricEncryptionAlgorithm = symmetricEncryptionAlgorithm;
        this.asymmetricSignatureAlgorithm = asymmetricSignatureAlgorithm;
        this.asymmetricEncryptionAlgorithm = asymmetricEncryptionAlgorithm;
        this.asymmetricKeyWrapAlgorithm = asymmetricKeyWrapAlgorithm;
        this.keyDerivationAlgorithm = keyDerivationAlgorithm;
        this.certificateSignatureAlgorithm = certificateSignatureAlgorithm;
    }

    public String getSecurityPolicyUri() {
        return this.securityPolicyUri;
    }

    public SecurityAlgorithm getSymmetricSignatureAlgorithm() {
        return this.symmetricSignatureAlgorithm;
    }

    public SecurityAlgorithm getSymmetricEncryptionAlgorithm() {
        return this.symmetricEncryptionAlgorithm;
    }

    public SecurityAlgorithm getAsymmetricSignatureAlgorithm() {
        return this.asymmetricSignatureAlgorithm;
    }

    public SecurityAlgorithm getAsymmetricEncryptionAlgorithm() {
        return this.asymmetricEncryptionAlgorithm;
    }

    public SecurityAlgorithm getAsymmetricKeyWrapAlgorithm() {
        return this.asymmetricKeyWrapAlgorithm;
    }

    public SecurityAlgorithm getKeyDerivationAlgorithm() {
        return this.keyDerivationAlgorithm;
    }

    public SecurityAlgorithm getCertificateSignatureAlgorithm() {
        return this.certificateSignatureAlgorithm;
    }

    public static SecurityPolicy fromUri(String securityPolicyUri) throws UaException {
        for (SecurityPolicy securityPolicy : SecurityPolicy.values()) {
            if (!securityPolicy.getSecurityPolicyUri().equals(securityPolicyUri)) continue;
            return securityPolicy;
        }
        throw new UaException(0x80550000L, "unknown securityPolicyUri: " + securityPolicyUri);
    }

    public static Optional<SecurityPolicy> fromUriSafe(String securityPolicyUri) {
        try {
            return Optional.of(SecurityPolicy.fromUri(securityPolicyUri));
        }
        catch (Throwable t) {
            return Optional.empty();
        }
    }
}

