/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.serialization;

import com.google.common.io.CharStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.milo.opcua.stack.core.UaRuntimeException;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaMessage;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.OpcUaXmlDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.SerializationContext;
import org.eclipse.milo.opcua.stack.core.types.BuiltinDataTypeDictionary;
import org.eclipse.milo.opcua.stack.core.types.OpcUaDataTypeManager;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.XmlElement;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.util.ArrayUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OpcUaXmlStreamDecoder
implements UaDecoder {
    private static final SerializationContext SERIALIZATION_CONTEXT = OpcUaDataTypeManager::getInstance;
    private static final DocumentBuilderFactory FACTORY = DocumentBuilderFactory.newInstance();
    private final DocumentBuilder builder;
    private Document document;
    private Node currentNode;

    public OpcUaXmlStreamDecoder() {
        try {
            this.builder = FACTORY.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new UaRuntimeException(0x80020000L, (Throwable)e);
        }
    }

    public OpcUaXmlStreamDecoder(Reader reader) throws IOException, SAXException {
        this();
        this.setInput(reader);
    }

    public OpcUaXmlStreamDecoder(InputStream inputStream) throws IOException, SAXException {
        this();
        this.setInput(inputStream);
    }

    public OpcUaXmlStreamDecoder setInput(Reader reader) throws IOException, SAXException {
        String s = CharStreams.toString((Readable)reader);
        return this.setInput(new ByteArrayInputStream(s.getBytes()));
    }

    public OpcUaXmlStreamDecoder setInput(InputStream inputStream) throws IOException, SAXException {
        this.document = this.builder.parse(inputStream);
        this.currentNode = this.document.getFirstChild();
        return this;
    }

    private Node currentNode(String field) throws UaSerializationException {
        if (this.currentNode == null) {
            throw new UaSerializationException(0x80070000L, "currentNode==null");
        }
        if (field != null && !field.equals(this.currentNode.getLocalName())) {
            throw new UaSerializationException(0x80070000L, String.format("expected '%s' found '%s'", field, this.currentNode.getLocalName()));
        }
        return this.currentNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean readBoolean(String field) throws UaSerializationException {
        Node node = this.currentNode(field);
        try {
            Boolean bl = DatatypeConverter.parseBoolean((String)node.getTextContent());
            return bl;
        }
        finally {
            this.currentNode = node.getNextSibling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Byte readSByte(String field) throws UaSerializationException {
        Node node = this.currentNode(field);
        try {
            Byte by = DatatypeConverter.parseByte((String)node.getTextContent());
            return by;
        }
        finally {
            this.currentNode = node.getNextSibling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Short readInt16(String field) throws UaSerializationException {
        Node node = this.currentNode(field);
        try {
            Short s = DatatypeConverter.parseShort((String)node.getTextContent());
            return s;
        }
        finally {
            this.currentNode = node.getNextSibling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer readInt32(String field) throws UaSerializationException {
        Node node = this.currentNode(field);
        try {
            Integer n = DatatypeConverter.parseInt((String)node.getTextContent());
            return n;
        }
        finally {
            this.currentNode = node.getNextSibling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long readInt64(String field) throws UaSerializationException {
        Node node = this.currentNode(field);
        try {
            Long l = DatatypeConverter.parseLong((String)node.getTextContent());
            return l;
        }
        finally {
            this.currentNode = node.getNextSibling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UByte readByte(String field) throws UaSerializationException {
        Node node = this.currentNode(field);
        try {
            UByte uByte = Unsigned.ubyte(DatatypeConverter.parseShort((String)node.getTextContent()));
            return uByte;
        }
        finally {
            this.currentNode = node.getNextSibling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UShort readUInt16(String field) throws UaSerializationException {
        Node node = this.currentNode(field);
        try {
            UShort uShort = Unsigned.ushort(DatatypeConverter.parseInt((String)node.getTextContent()));
            return uShort;
        }
        finally {
            this.currentNode = node.getNextSibling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UInteger readUInt32(String field) throws UaSerializationException {
        Node node = this.currentNode(field);
        try {
            UInteger uInteger = Unsigned.uint(DatatypeConverter.parseLong((String)node.getTextContent()));
            return uInteger;
        }
        finally {
            this.currentNode = node.getNextSibling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ULong readUInt64(String field) throws UaSerializationException {
        Node node = this.currentNode(field);
        try {
            ULong uLong = Unsigned.ulong(DatatypeConverter.parseInteger((String)node.getTextContent()));
            return uLong;
        }
        finally {
            this.currentNode = node.getNextSibling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Float readFloat(String field) throws UaSerializationException {
        Node node = this.currentNode(field);
        try {
            Float f = Float.valueOf(DatatypeConverter.parseFloat((String)node.getTextContent()));
            return f;
        }
        finally {
            this.currentNode = node.getNextSibling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double readDouble(String field) throws UaSerializationException {
        Node node = this.currentNode(field);
        try {
            Double d = DatatypeConverter.parseDouble((String)node.getTextContent());
            return d;
        }
        finally {
            this.currentNode = node.getNextSibling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readString(String field) throws UaSerializationException {
        Node node = this.currentNode(field);
        try {
            String string = node.getTextContent();
            return string;
        }
        finally {
            this.currentNode = node.getNextSibling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DateTime readDateTime(String field) throws UaSerializationException {
        Node node = this.currentNode(field);
        try {
            Calendar calendar = DatatypeConverter.parseDateTime((String)node.getTextContent());
            DateTime dateTime = new DateTime(calendar.getTime());
            return dateTime;
        }
        finally {
            this.currentNode = node.getNextSibling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID readGuid(String field) throws UaSerializationException {
        Node node = this.currentNode(field);
        try {
            UUID uUID = UUID.fromString(node.getTextContent());
            return uUID;
        }
        finally {
            this.currentNode = node.getNextSibling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteString readByteString(String field) throws UaSerializationException {
        Node node = this.currentNode(field);
        try {
            byte[] bs = DatatypeConverter.parseBase64Binary((String)node.getTextContent());
            ByteString byteString = ByteString.of(bs);
            return byteString;
        }
        finally {
            this.currentNode = node.getNextSibling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XmlElement readXmlElement(String field) throws UaSerializationException {
        Node node = this.currentNode(field);
        try {
            XmlElement xmlElement = OpcUaXmlStreamDecoder.nodeToXmlElement(node);
            return xmlElement;
        }
        finally {
            this.currentNode = node.getNextSibling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeId readNodeId(String field) throws UaSerializationException {
        Node node = this.currentNode(field);
        Node idNode = node.getFirstChild();
        try {
            if (idNode != null) {
                NodeId nodeId = NodeId.parse(idNode.getTextContent());
                return nodeId;
            }
            NodeId nodeId = NodeId.NULL_VALUE;
            return nodeId;
        }
        finally {
            this.currentNode = node.getNextSibling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExpandedNodeId readExpandedNodeId(String field) throws UaSerializationException {
        Node node = this.currentNode(field);
        Node expandedIdNode = node.getFirstChild();
        try {
            if (expandedIdNode != null) {
                ExpandedNodeId expandedNodeId = ExpandedNodeId.parse(expandedIdNode.getTextContent());
                return expandedNodeId;
            }
            ExpandedNodeId expandedNodeId = ExpandedNodeId.NULL_VALUE;
            return expandedNodeId;
        }
        finally {
            this.currentNode = node.getNextSibling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatusCode readStatusCode(String field) throws UaSerializationException {
        Node node = this.currentNode(field);
        try {
            long code = 0L;
            Node codeNode = node.getFirstChild();
            if (codeNode != null) {
                code = DatatypeConverter.parseUnsignedInt((String)codeNode.getTextContent());
            }
            StatusCode statusCode = new StatusCode(code);
            return statusCode;
        }
        finally {
            this.currentNode = node.getNextSibling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QualifiedName readQualifiedName(String field) throws UaSerializationException {
        Node nameNode;
        Node node = this.currentNode(field);
        Map<String, Node> children = OpcUaXmlStreamDecoder.nodeMap(node.getChildNodes());
        int namespaceIndex = 0;
        String name = null;
        Node namespaceIndexNode = children.get("NamespaceIndex");
        if (namespaceIndexNode != null) {
            namespaceIndex = DatatypeConverter.parseInt((String)namespaceIndexNode.getTextContent());
        }
        if ((nameNode = children.get("Name")) != null) {
            name = nameNode.getTextContent();
        }
        try {
            QualifiedName qualifiedName = new QualifiedName(namespaceIndex, name);
            return qualifiedName;
        }
        finally {
            this.currentNode = node.getNextSibling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocalizedText readLocalizedText(String field) throws UaSerializationException {
        Node textNode;
        Node node = this.currentNode(field);
        Map<String, Node> children = OpcUaXmlStreamDecoder.nodeMap(node.getChildNodes());
        String locale = null;
        String text = null;
        Node localeNode = children.get("Locale");
        if (localeNode != null) {
            locale = localeNode.getTextContent();
        }
        if ((textNode = children.get("Text")) != null) {
            text = textNode.getTextContent();
        }
        try {
            LocalizedText localizedText = new LocalizedText(locale, text);
            return localizedText;
        }
        finally {
            this.currentNode = node.getNextSibling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExtensionObject readExtensionObject(String field) throws UaSerializationException {
        Node bodyNode;
        Node node = this.currentNode(field);
        Map<String, Node> children = OpcUaXmlStreamDecoder.nodeMap(node.getChildNodes());
        NodeId typeId = NodeId.NULL_VALUE;
        ExtensionObject extensionObject = new ExtensionObject(new XmlElement(""), NodeId.NULL_VALUE);
        Node typeIdNode = children.get("TypeId");
        if (typeIdNode != null) {
            this.currentNode = typeIdNode;
            typeId = this.readNodeId("TypeId");
        }
        if ((bodyNode = children.get("Body")) != null) {
            if ("ByteString".equals(bodyNode.getLocalName()) && "http://opcfoundation.org/UA/2008/02/Types.xsd".equals(bodyNode.getNamespaceURI())) {
                this.currentNode = bodyNode;
                extensionObject = new ExtensionObject(this.readByteString("ByteString"), typeId);
            } else {
                extensionObject = new ExtensionObject(OpcUaXmlStreamDecoder.nodeToXmlElement(bodyNode), typeId);
            }
        }
        try {
            ExtensionObject extensionObject2 = extensionObject;
            return extensionObject2;
        }
        finally {
            this.currentNode = node.getNextSibling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataValue readDataValue(String field) throws UaSerializationException {
        Node node = this.currentNode(field);
        Map<String, Node> children = OpcUaXmlStreamDecoder.nodeMap(node.getChildNodes());
        Variant value = Variant.NULL_VALUE;
        StatusCode statusCode = StatusCode.GOOD;
        DateTime sourceTimestamp = null;
        UShort sourcePicoseconds = null;
        DateTime serverTimestamp = null;
        UShort serverPicoseconds = null;
        try {
            Node serverPicosecondsNode;
            Node serverTimestampNode;
            Node sourcePicosecondsNode;
            Node sourceTimestampNode;
            Node statusCodeNode;
            Node valueNode = children.get("Value");
            if (valueNode != null) {
                this.currentNode = valueNode;
                value = this.readVariant("Value");
            }
            if ((statusCodeNode = children.get("StatusCode")) != null) {
                this.currentNode = statusCodeNode;
                statusCode = this.readStatusCode("StatusCode");
            }
            if ((sourceTimestampNode = children.get("SourceTimestamp")) != null) {
                this.currentNode = sourceTimestampNode;
                sourceTimestamp = this.readDateTime("SourceTimestamp");
            }
            if ((sourcePicosecondsNode = children.get("SourcePicoseconds")) != null) {
                this.currentNode = sourcePicosecondsNode;
                sourcePicoseconds = this.readUInt16("SourcePicoseconds");
            }
            if ((serverTimestampNode = children.get("ServerTimestamp")) != null) {
                this.currentNode = serverTimestampNode;
                serverTimestamp = this.readDateTime("ServerTimestamp");
            }
            if ((serverPicosecondsNode = children.get("ServerPicoseconds")) != null) {
                this.currentNode = serverPicosecondsNode;
                serverPicoseconds = this.readUInt16("ServerPicoseconds");
            }
            DataValue dataValue = new DataValue(value, statusCode, sourceTimestamp, sourcePicoseconds, serverTimestamp, serverPicoseconds);
            return dataValue;
        }
        finally {
            this.currentNode = node.getNextSibling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Variant readVariant(String field) throws UaSerializationException {
        Node node = this.currentNode(field);
        this.currentNode = node.getFirstChild().getFirstChild();
        Object value = this.readVariantValue();
        try {
            Variant variant = new Variant(value);
            return variant;
        }
        finally {
            this.currentNode = node.getNextSibling();
        }
    }

    public Object readVariantValue() {
        Node node = this.currentNode(null);
        String nodeName = node.getLocalName();
        if (nodeName.startsWith("ListOf")) {
            String type = nodeName.substring(6);
            ArrayList<Object> values = new ArrayList<Object>();
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                this.currentNode = childNodes.item(i);
                if (this.currentNode.getNodeType() != 1) continue;
                values.add(this.readBuiltinType(type, type));
            }
            Object array = Array.newInstance(OpcUaXmlStreamDecoder.builtinTypeClass(type), values.size());
            for (int i = 0; i < values.size(); ++i) {
                Array.set(array, i, values.get(i));
            }
            return array;
        }
        if (nodeName.equals("Matrix")) {
            ArrayList<Integer> dimensions = new ArrayList<Integer>();
            Node child = node.getFirstChild();
            for (int i = 0; i < child.getChildNodes().getLength(); ++i) {
                this.currentNode = child.getChildNodes().item(i);
                if (this.currentNode.getNodeType() != 1) continue;
                dimensions.add(this.readInt32("Int32"));
            }
            ArrayList<Object> elements = new ArrayList<Object>();
            child = child.getNextSibling();
            for (int i = 0; i < child.getChildNodes().getLength(); ++i) {
                this.currentNode = child.getChildNodes().item(i);
                if (this.currentNode.getNodeType() != 1) continue;
                String type = this.currentNode.getLocalName();
                elements.add(this.readBuiltinType(type, type));
            }
            Class<?> clazz = elements.get(0).getClass();
            Object array = Array.newInstance(clazz, elements.size());
            for (int i = 0; i < elements.size(); ++i) {
                Array.set(array, i, elements.get(i));
            }
            int[] dims = new int[dimensions.size()];
            for (int i = 0; i < dimensions.size(); ++i) {
                dims[i] = (Integer)dimensions.get(i);
            }
            return ArrayUtil.unflatten(array, dims);
        }
        return this.readBuiltinType(nodeName, nodeName);
    }

    private Object readBuiltinType(String field, String type) {
        switch (type) {
            case "Boolean": {
                return this.readBoolean(field);
            }
            case "SByte": {
                return this.readSByte(field);
            }
            case "Int16": {
                return this.readInt16(field);
            }
            case "Int32": {
                return this.readInt32(field);
            }
            case "Int64": {
                return this.readInt64(field);
            }
            case "Byte": {
                return this.readByte(field);
            }
            case "UInt16": {
                return this.readUInt16(field);
            }
            case "UInt32": {
                return this.readUInt32(field);
            }
            case "UInt64": {
                return this.readUInt64(field);
            }
            case "Float": {
                return this.readFloat(field);
            }
            case "Double": {
                return this.readDouble(field);
            }
            case "String": {
                return this.readString(field);
            }
            case "DateTime": {
                return this.readDateTime(field);
            }
            case "Guid": {
                return this.readGuid(field);
            }
            case "ByteString": {
                return this.readByteString(field);
            }
            case "XmlElement": {
                return this.readXmlElement(field);
            }
            case "NodeId": {
                return this.readNodeId(field);
            }
            case "ExpandedNodeId": {
                return this.readExpandedNodeId(field);
            }
            case "StatusCode": {
                return this.readStatusCode(field);
            }
            case "QualifiedName": {
                return this.readQualifiedName(field);
            }
            case "LocalizedText": {
                return this.readLocalizedText(field);
            }
            case "ExtensionObject": {
                return this.readExtensionObject(field);
            }
            case "DataValue": {
                return this.readDataValue(field);
            }
            case "Variant": {
                return this.readVariant(field);
            }
            case "DiagnosticInfo": {
                return this.readDiagnosticInfo(field);
            }
        }
        throw new UaSerializationException(0x80070000L, "not builtin type: " + type);
    }

    private static Class<?> builtinTypeClass(String type) {
        switch (type) {
            case "Boolean": {
                return Boolean.class;
            }
            case "SByte": {
                return Byte.class;
            }
            case "Int16": {
                return Short.class;
            }
            case "Int32": {
                return Integer.class;
            }
            case "Int64": {
                return Long.class;
            }
            case "Byte": {
                return UByte.class;
            }
            case "UInt16": {
                return UShort.class;
            }
            case "UInt32": {
                return UInteger.class;
            }
            case "UInt64": {
                return ULong.class;
            }
            case "Float": {
                return Float.class;
            }
            case "Double": {
                return Double.class;
            }
            case "String": {
                return String.class;
            }
            case "DateTime": {
                return DateTime.class;
            }
            case "Guid": {
                return UUID.class;
            }
            case "ByteString": {
                return ByteString.class;
            }
            case "XmlElement": {
                return XmlElement.class;
            }
            case "NodeId": {
                return NodeId.class;
            }
            case "ExpandedNodeId": {
                return ExpandedNodeId.class;
            }
            case "StatusCode": {
                return StatusCode.class;
            }
            case "QualifiedName": {
                return QualifiedName.class;
            }
            case "LocalizedText": {
                return LocalizedText.class;
            }
            case "ExtensionObject": {
                return ExtensionObject.class;
            }
            case "DataValue": {
                return DataValue.class;
            }
            case "Variant": {
                return Variant.class;
            }
            case "DiagnosticInfo": {
                return DiagnosticInfo.class;
            }
        }
        throw new UaSerializationException(0x80070000L, "not builtin type: " + type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiagnosticInfo readDiagnosticInfo(String field) throws UaSerializationException {
        Node node = this.currentNode(field);
        Map<String, Node> children = OpcUaXmlStreamDecoder.nodeMap(node.getChildNodes());
        int symbolicId = -1;
        int namespaceUri = -1;
        int locale = -1;
        int localizedText = -1;
        String additionalInfo = null;
        StatusCode innerStatusCode = null;
        DiagnosticInfo innerDiagnosticInfo = null;
        Node child = children.get("SymbolicId");
        if (child != null) {
            this.currentNode = child;
            symbolicId = this.readInt32("SymbolicId");
        }
        if ((child = children.get("NamespaceUri")) != null) {
            this.currentNode = child;
            namespaceUri = this.readInt32("NamespaceUri");
        }
        if ((child = children.get("Locale")) != null) {
            this.currentNode = child;
            locale = this.readInt32("Locale");
        }
        if ((child = children.get("LocalizedText")) != null) {
            this.currentNode = child;
            localizedText = this.readInt32("LocalizedText");
        }
        if ((child = children.get("AdditionalInfo")) != null) {
            this.currentNode = child;
            additionalInfo = this.readString("AdditionalInfo");
        }
        if ((child = children.get("InnerStatusCode")) != null) {
            this.currentNode = child;
            innerStatusCode = this.readStatusCode("InnerStatusCode");
        }
        if ((child = children.get("InnerDiagnosticInfo")) != null) {
            this.currentNode = child;
            innerDiagnosticInfo = this.readDiagnosticInfo("InnerDiagnosticInfo");
        }
        try {
            DiagnosticInfo diagnosticInfo = new DiagnosticInfo(namespaceUri, symbolicId, locale, localizedText, additionalInfo, innerStatusCode, innerDiagnosticInfo);
            return diagnosticInfo;
        }
        finally {
            this.currentNode = node.getNextSibling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] readArray(String field, Function<String, T> decoder, Class<T> clazz) throws UaSerializationException {
        Node node = this.currentNode(field);
        ArrayList<T> values = new ArrayList<T>();
        Node listNode = node.getFirstChild();
        NodeList children = listNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            this.currentNode = children.item(i);
            if (this.currentNode.getNodeType() != 1) continue;
            values.add(decoder.apply(this.currentNode.getLocalName()));
        }
        try {
            Object array = Array.newInstance(clazz, values.size());
            for (int i = 0; i < values.size(); ++i) {
                Array.set(array, i, values.get(i));
            }
            Object[] objectArray = (Object[])array;
            return objectArray;
        }
        finally {
            this.currentNode = node.getNextSibling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends UaStructure> T readBuiltinStruct(String field, Class<T> typeClass) throws UaSerializationException {
        Node node = this.currentNode(field);
        BuiltinDataTypeCodec<?> codec = BuiltinDataTypeDictionary.getBuiltinCodec(typeClass);
        if (codec == null) {
            throw new UaSerializationException(0x80070000L, "no codec registered: " + typeClass);
        }
        try {
            Object obj = codec.decode(SERIALIZATION_CONTEXT, this);
            return (T)obj;
        }
        finally {
            this.currentNode = node.getNextSibling();
        }
    }

    @Override
    public <T extends UaStructure> T[] readBuiltinStructArray(String field, Class<T> clazz) throws UaSerializationException {
        return this.readArray(field, f -> this.readBuiltinStruct(null, clazz), clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object readStruct(String field, NodeId encodingId) throws UaSerializationException {
        Node node = this.currentNode(field);
        OpcUaXmlDataTypeCodec<?> codec = OpcUaDataTypeManager.getInstance().getXmlCodec(encodingId);
        if (codec == null) {
            throw new UaSerializationException(0x80070000L, "no codec registered: " + encodingId);
        }
        try {
            Object obj = codec.decode(SERIALIZATION_CONTEXT, this);
            return obj;
        }
        finally {
            this.currentNode = node.getNextSibling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] readStructArray(String field, NodeId encodingId) throws UaSerializationException {
        Node node = this.currentNode(field);
        OpcUaXmlDataTypeCodec<?> codec = OpcUaDataTypeManager.getInstance().getXmlCodec(encodingId);
        if (codec == null) {
            throw new UaSerializationException(0x80070000L, "no codec registered: " + encodingId);
        }
        ArrayList<Object> values = new ArrayList<Object>();
        Node listNode = node.getFirstChild();
        NodeList children = listNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            this.currentNode = children.item(i);
            if (this.currentNode.getNodeType() != 1) continue;
            values.add(this.readStruct(this.currentNode.getLocalName(), encodingId));
        }
        try {
            Object array = Array.newInstance(codec.getType(), values.size());
            for (int i = 0; i < values.size(); ++i) {
                Array.set(array, i, values.get(i));
            }
            Object[] objectArray = (Object[])array;
            return objectArray;
        }
        finally {
            this.currentNode = node.getNextSibling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UaMessage readMessage(String field) throws UaSerializationException {
        Node node = this.currentNode(field);
        String typeName = node.getLocalName();
        BuiltinDataTypeCodec<?> codec = BuiltinDataTypeDictionary.getBuiltinCodec(typeName);
        if (codec == null) {
            throw new UaSerializationException(0x80070000L, "no codec registered: " + typeName);
        }
        this.currentNode = node.getFirstChild();
        try {
            UaMessage uaMessage = (UaMessage)codec.decode(SERIALIZATION_CONTEXT, this);
            return uaMessage;
        }
        finally {
            this.currentNode = node.getNextSibling();
        }
    }

    private static XmlElement nodeToXmlElement(Node node) throws UaSerializationException {
        try {
            StringWriter sw = new StringWriter();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(node), new StreamResult(sw));
            return new XmlElement(sw.toString());
        }
        catch (TransformerException e) {
            throw new UaSerializationException(0x80070000L, (Throwable)e);
        }
    }

    private static Map<String, Node> nodeMap(NodeList nodeList) {
        LinkedHashMap<String, Node> nodeMap = new LinkedHashMap<String, Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            nodeMap.put(node.getLocalName(), node);
        }
        return nodeMap;
    }

    static {
        FACTORY.setCoalescing(true);
        FACTORY.setNamespaceAware(true);
    }
}

