/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.serialization;

import java.util.UUID;
import java.util.function.BiConsumer;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaMessage;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.XmlElement;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;

public interface UaEncoder {
    public void writeBoolean(String var1, Boolean var2) throws UaSerializationException;

    public void writeSByte(String var1, Byte var2) throws UaSerializationException;

    public void writeInt16(String var1, Short var2) throws UaSerializationException;

    public void writeInt32(String var1, Integer var2) throws UaSerializationException;

    public void writeInt64(String var1, Long var2) throws UaSerializationException;

    public void writeByte(String var1, UByte var2) throws UaSerializationException;

    public void writeUInt16(String var1, UShort var2) throws UaSerializationException;

    public void writeUInt32(String var1, UInteger var2) throws UaSerializationException;

    public void writeUInt64(String var1, ULong var2) throws UaSerializationException;

    public void writeFloat(String var1, Float var2) throws UaSerializationException;

    public void writeDouble(String var1, Double var2) throws UaSerializationException;

    public void writeString(String var1, String var2) throws UaSerializationException;

    public void writeDateTime(String var1, DateTime var2) throws UaSerializationException;

    public void writeGuid(String var1, UUID var2) throws UaSerializationException;

    public void writeByteString(String var1, ByteString var2) throws UaSerializationException;

    public void writeXmlElement(String var1, XmlElement var2) throws UaSerializationException;

    public void writeNodeId(String var1, NodeId var2) throws UaSerializationException;

    public void writeExpandedNodeId(String var1, ExpandedNodeId var2) throws UaSerializationException;

    public void writeStatusCode(String var1, StatusCode var2) throws UaSerializationException;

    public void writeQualifiedName(String var1, QualifiedName var2) throws UaSerializationException;

    public void writeLocalizedText(String var1, LocalizedText var2) throws UaSerializationException;

    public void writeExtensionObject(String var1, ExtensionObject var2) throws UaSerializationException;

    public void writeDataValue(String var1, DataValue var2) throws UaSerializationException;

    public void writeVariant(String var1, Variant var2) throws UaSerializationException;

    public void writeDiagnosticInfo(String var1, DiagnosticInfo var2) throws UaSerializationException;

    public <T> void writeArray(String var1, T[] var2, BiConsumer<String, T> var3) throws UaSerializationException;

    public <T extends UaStructure> void writeBuiltinStruct(String var1, T var2, Class<T> var3) throws UaSerializationException;

    public <T extends UaStructure> void writeBuiltinStructArray(String var1, T[] var2, Class<T> var3) throws UaSerializationException;

    public void writeStruct(String var1, Object var2, NodeId var3) throws UaSerializationException;

    public void writeStructArray(String var1, Object[] var2, NodeId var3) throws UaSerializationException;

    public void writeMessage(String var1, UaMessage var2) throws UaSerializationException;
}

