/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types;

import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.OpcUaXmlDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.DataTypeDictionary;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

public class OpcUaXmlDataTypeDictionary
implements DataTypeDictionary<OpcUaXmlDataTypeCodec<?>> {
    private final String namespaceUri;
    private final Map<String, OpcUaXmlDataTypeCodec<?>> codecsByDescription;
    private final Map<NodeId, OpcUaXmlDataTypeCodec<?>> codecsByEncodingId;

    public OpcUaXmlDataTypeDictionary(String namespaceUri) {
        this.namespaceUri = namespaceUri;
        this.codecsByDescription = Maps.newConcurrentMap();
        this.codecsByEncodingId = Maps.newConcurrentMap();
    }

    public OpcUaXmlDataTypeDictionary(String namespaceUri, Map<String, OpcUaXmlDataTypeCodec<?>> byDescription, Map<NodeId, OpcUaXmlDataTypeCodec<?>> byEncodingId) {
        this.namespaceUri = namespaceUri;
        this.codecsByDescription = Maps.newConcurrentMap();
        this.codecsByDescription.putAll(byDescription);
        this.codecsByEncodingId = Maps.newConcurrentMap();
        this.codecsByEncodingId.putAll(byEncodingId);
    }

    @Override
    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    @Override
    public OpcUaXmlDataTypeCodec<?> getCodec(String description) {
        return this.codecsByDescription.get(description);
    }

    @Override
    public OpcUaXmlDataTypeCodec<?> getCodec(NodeId encodingId) {
        return this.codecsByEncodingId.get(encodingId);
    }

    @Override
    public void registerEnumCodec(OpcUaXmlDataTypeCodec<?> codec, String description) {
        this.codecsByDescription.put(description, codec);
    }

    @Override
    public void registerStructCodec(OpcUaXmlDataTypeCodec<?> codec, String description, NodeId encodingId) {
        this.codecsByDescription.put(description, codec);
        this.codecsByEncodingId.put(encodingId, codec);
    }

    @Override
    public Map<String, OpcUaXmlDataTypeCodec<?>> getCodecsByDescription() {
        return this.codecsByDescription;
    }

    @Override
    public Map<NodeId, OpcUaXmlDataTypeCodec<?>> getCodecsByEncodingId() {
        return this.codecsByEncodingId;
    }
}

