/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import com.google.common.collect.ImmutableMap;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;

public enum AttributeWriteMask implements UaEnumeration
{
    None(0),
    AccessLevel(1),
    ArrayDimensions(2),
    BrowseName(4),
    ContainsNoLoops(8),
    DataType(16),
    Description(32),
    DisplayName(64),
    EventNotifier(128),
    Executable(256),
    Historizing(512),
    InverseName(1024),
    IsAbstract(2048),
    MinimumSamplingInterval(4096),
    NodeClass(8192),
    NodeId(16384),
    Symmetric(32768),
    UserAccessLevel(65536),
    UserExecutable(131072),
    UserWriteMask(262144),
    ValueRank(524288),
    WriteMask(0x100000),
    ValueForVariableType(0x200000);

    private final int value;
    private static final ImmutableMap<Integer, AttributeWriteMask> VALUES;

    private AttributeWriteMask(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static AttributeWriteMask from(Integer value) {
        if (value == null) {
            return null;
        }
        return (AttributeWriteMask)VALUES.getOrDefault((Object)value, null);
    }

    public static void encode(AttributeWriteMask attributeWriteMask, UaEncoder encoder) {
        encoder.writeInt32(null, attributeWriteMask.getValue());
    }

    public static AttributeWriteMask decode(UaDecoder decoder) {
        int value = decoder.readInt32(null);
        return (AttributeWriteMask)VALUES.getOrDefault((Object)value, null);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (AttributeWriteMask e : AttributeWriteMask.values()) {
            builder.put((Object)e.getValue(), (Object)e);
        }
        VALUES = builder.build();
    }
}

