/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import com.google.common.collect.ImmutableMap;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;

public enum DataChangeTrigger implements UaEnumeration
{
    Status(0),
    StatusValue(1),
    StatusValueTimestamp(2);

    private final int value;
    private static final ImmutableMap<Integer, DataChangeTrigger> VALUES;

    private DataChangeTrigger(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static DataChangeTrigger from(Integer value) {
        if (value == null) {
            return null;
        }
        return (DataChangeTrigger)VALUES.getOrDefault((Object)value, null);
    }

    public static void encode(DataChangeTrigger dataChangeTrigger, UaEncoder encoder) {
        encoder.writeInt32(null, dataChangeTrigger.getValue());
    }

    public static DataChangeTrigger decode(UaDecoder decoder) {
        int value = decoder.readInt32(null);
        return (DataChangeTrigger)VALUES.getOrDefault((Object)value, null);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (DataChangeTrigger e : DataChangeTrigger.values()) {
            builder.put((Object)e.getValue(), (Object)e);
        }
        VALUES = builder.build();
    }
}

