/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import com.google.common.collect.ImmutableMap;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;

public enum EnumeratedTestType implements UaEnumeration
{
    Red(1),
    Yellow(4),
    Green(5);

    private final int value;
    private static final ImmutableMap<Integer, EnumeratedTestType> VALUES;

    private EnumeratedTestType(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static EnumeratedTestType from(Integer value) {
        if (value == null) {
            return null;
        }
        return (EnumeratedTestType)VALUES.getOrDefault((Object)value, null);
    }

    public static void encode(EnumeratedTestType enumeratedTestType, UaEncoder encoder) {
        encoder.writeInt32(null, enumeratedTestType.getValue());
    }

    public static EnumeratedTestType decode(UaDecoder decoder) {
        int value = decoder.readInt32(null);
        return (EnumeratedTestType)VALUES.getOrDefault((Object)value, null);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EnumeratedTestType e : EnumeratedTestType.values()) {
            builder.put((Object)e.getValue(), (Object)e);
        }
        VALUES = builder.build();
    }
}

