/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import com.google.common.collect.ImmutableMap;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;

public enum MonitoringMode implements UaEnumeration
{
    Disabled(0),
    Sampling(1),
    Reporting(2);

    private final int value;
    private static final ImmutableMap<Integer, MonitoringMode> VALUES;

    private MonitoringMode(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static MonitoringMode from(Integer value) {
        if (value == null) {
            return null;
        }
        return (MonitoringMode)VALUES.getOrDefault((Object)value, null);
    }

    public static void encode(MonitoringMode monitoringMode, UaEncoder encoder) {
        encoder.writeInt32(null, monitoringMode.getValue());
    }

    public static MonitoringMode decode(UaDecoder decoder) {
        int value = decoder.readInt32(null);
        return (MonitoringMode)VALUES.getOrDefault((Object)value, null);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (MonitoringMode e : MonitoringMode.values()) {
            builder.put((Object)e.getValue(), (Object)e);
        }
        VALUES = builder.build();
    }
}

