/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import com.google.common.collect.ImmutableMap;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;

public enum NodeIdType implements UaEnumeration
{
    TwoByte(0),
    FourByte(1),
    Numeric(2),
    String(3),
    Guid(4),
    ByteString(5);

    private final int value;
    private static final ImmutableMap<Integer, NodeIdType> VALUES;

    private NodeIdType(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static NodeIdType from(Integer value) {
        if (value == null) {
            return null;
        }
        return (NodeIdType)VALUES.getOrDefault((Object)value, null);
    }

    public static void encode(NodeIdType nodeIdType, UaEncoder encoder) {
        encoder.writeInt32(null, nodeIdType.getValue());
    }

    public static NodeIdType decode(UaDecoder decoder) {
        int value = decoder.readInt32(null);
        return (NodeIdType)VALUES.getOrDefault((Object)value, null);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (NodeIdType e : NodeIdType.values()) {
            builder.put((Object)e.getValue(), (Object)e);
        }
        VALUES = builder.build();
    }
}

