/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import com.google.common.collect.ImmutableMap;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;

public enum OpenFileMode implements UaEnumeration
{
    Read(1),
    Write(2),
    EraseExisting(4),
    Append(8);

    private final int value;
    private static final ImmutableMap<Integer, OpenFileMode> VALUES;

    private OpenFileMode(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static OpenFileMode from(Integer value) {
        if (value == null) {
            return null;
        }
        return (OpenFileMode)VALUES.getOrDefault((Object)value, null);
    }

    public static void encode(OpenFileMode openFileMode, UaEncoder encoder) {
        encoder.writeInt32(null, openFileMode.getValue());
    }

    public static OpenFileMode decode(UaDecoder decoder) {
        int value = decoder.readInt32(null);
        return (OpenFileMode)VALUES.getOrDefault((Object)value, null);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (OpenFileMode e : OpenFileMode.values()) {
            builder.put((Object)e.getValue(), (Object)e);
        }
        VALUES = builder.build();
    }
}

