/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import com.google.common.collect.ImmutableMap;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;

public enum UserTokenType implements UaEnumeration
{
    Anonymous(0),
    UserName(1),
    Certificate(2),
    IssuedToken(3),
    Kerberos(4);

    private final int value;
    private static final ImmutableMap<Integer, UserTokenType> VALUES;

    private UserTokenType(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static UserTokenType from(Integer value) {
        if (value == null) {
            return null;
        }
        return (UserTokenType)VALUES.getOrDefault((Object)value, null);
    }

    public static void encode(UserTokenType userTokenType, UaEncoder encoder) {
        encoder.writeInt32(null, userTokenType.getValue());
    }

    public static UserTokenType decode(UaDecoder decoder) {
        int value = decoder.readInt32(null);
        return (UserTokenType)VALUES.getOrDefault((Object)value, null);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (UserTokenType e : UserTokenType.values()) {
            builder.put((Object)e.getValue(), (Object)e);
        }
        VALUES = builder.build();
    }
}

