/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.SignatureData;
import org.eclipse.milo.opcua.stack.core.types.structured.SignedSoftwareCertificate;

public class ActivateSessionRequest
implements UaRequestMessage {
    public static final NodeId TypeId = Identifiers.ActivateSessionRequest;
    public static final NodeId BinaryEncodingId = Identifiers.ActivateSessionRequest_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.ActivateSessionRequest_Encoding_DefaultXml;
    protected final RequestHeader requestHeader;
    protected final SignatureData clientSignature;
    protected final SignedSoftwareCertificate[] clientSoftwareCertificates;
    protected final String[] localeIds;
    protected final ExtensionObject userIdentityToken;
    protected final SignatureData userTokenSignature;

    public ActivateSessionRequest() {
        this.requestHeader = null;
        this.clientSignature = null;
        this.clientSoftwareCertificates = null;
        this.localeIds = null;
        this.userIdentityToken = null;
        this.userTokenSignature = null;
    }

    public ActivateSessionRequest(RequestHeader requestHeader, SignatureData clientSignature, SignedSoftwareCertificate[] clientSoftwareCertificates, String[] localeIds, ExtensionObject userIdentityToken, SignatureData userTokenSignature) {
        this.requestHeader = requestHeader;
        this.clientSignature = clientSignature;
        this.clientSoftwareCertificates = clientSoftwareCertificates;
        this.localeIds = localeIds;
        this.userIdentityToken = userIdentityToken;
        this.userTokenSignature = userTokenSignature;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public SignatureData getClientSignature() {
        return this.clientSignature;
    }

    @Nullable
    public SignedSoftwareCertificate[] getClientSoftwareCertificates() {
        return this.clientSoftwareCertificates;
    }

    @Nullable
    public String[] getLocaleIds() {
        return this.localeIds;
    }

    public ExtensionObject getUserIdentityToken() {
        return this.userIdentityToken;
    }

    public SignatureData getUserTokenSignature() {
        return this.userTokenSignature;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("RequestHeader", (Object)this.requestHeader).add("ClientSignature", (Object)this.clientSignature).add("ClientSoftwareCertificates", (Object)this.clientSoftwareCertificates).add("LocaleIds", (Object)this.localeIds).add("UserIdentityToken", (Object)this.userIdentityToken).add("UserTokenSignature", (Object)this.userTokenSignature).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<ActivateSessionRequest> {
        @Override
        public Class<ActivateSessionRequest> getType() {
            return ActivateSessionRequest.class;
        }

        @Override
        public ActivateSessionRequest decode(UaDecoder decoder) throws UaSerializationException {
            RequestHeader requestHeader = decoder.readBuiltinStruct("RequestHeader", RequestHeader.class);
            SignatureData clientSignature = decoder.readBuiltinStruct("ClientSignature", SignatureData.class);
            SignedSoftwareCertificate[] clientSoftwareCertificates = (SignedSoftwareCertificate[])decoder.readBuiltinStructArray("ClientSoftwareCertificates", SignedSoftwareCertificate.class);
            String[] localeIds = decoder.readArray("LocaleIds", decoder::readString, String.class);
            ExtensionObject userIdentityToken = decoder.readExtensionObject("UserIdentityToken");
            SignatureData userTokenSignature = decoder.readBuiltinStruct("UserTokenSignature", SignatureData.class);
            return new ActivateSessionRequest(requestHeader, clientSignature, clientSoftwareCertificates, localeIds, userIdentityToken, userTokenSignature);
        }

        @Override
        public void encode(ActivateSessionRequest value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStruct("RequestHeader", value.requestHeader, RequestHeader.class);
            encoder.writeBuiltinStruct("ClientSignature", value.clientSignature, SignatureData.class);
            encoder.writeBuiltinStructArray("ClientSoftwareCertificates", value.clientSoftwareCertificates, SignedSoftwareCertificate.class);
            encoder.writeArray("LocaleIds", value.localeIds, encoder::writeString);
            encoder.writeExtensionObject("UserIdentityToken", value.userIdentityToken);
            encoder.writeBuiltinStruct("UserTokenSignature", value.userTokenSignature, SignatureData.class);
        }
    }
}

