/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;

public class ActivateSessionResponse
implements UaResponseMessage {
    public static final NodeId TypeId = Identifiers.ActivateSessionResponse;
    public static final NodeId BinaryEncodingId = Identifiers.ActivateSessionResponse_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.ActivateSessionResponse_Encoding_DefaultXml;
    protected final ResponseHeader responseHeader;
    protected final ByteString serverNonce;
    protected final StatusCode[] results;
    protected final DiagnosticInfo[] diagnosticInfos;

    public ActivateSessionResponse() {
        this.responseHeader = null;
        this.serverNonce = null;
        this.results = null;
        this.diagnosticInfos = null;
    }

    public ActivateSessionResponse(ResponseHeader responseHeader, ByteString serverNonce, StatusCode[] results, DiagnosticInfo[] diagnosticInfos) {
        this.responseHeader = responseHeader;
        this.serverNonce = serverNonce;
        this.results = results;
        this.diagnosticInfos = diagnosticInfos;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public ByteString getServerNonce() {
        return this.serverNonce;
    }

    @Nullable
    public StatusCode[] getResults() {
        return this.results;
    }

    @Nullable
    public DiagnosticInfo[] getDiagnosticInfos() {
        return this.diagnosticInfos;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ResponseHeader", (Object)this.responseHeader).add("ServerNonce", (Object)this.serverNonce).add("Results", (Object)this.results).add("DiagnosticInfos", (Object)this.diagnosticInfos).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<ActivateSessionResponse> {
        @Override
        public Class<ActivateSessionResponse> getType() {
            return ActivateSessionResponse.class;
        }

        @Override
        public ActivateSessionResponse decode(UaDecoder decoder) throws UaSerializationException {
            ResponseHeader responseHeader = decoder.readBuiltinStruct("ResponseHeader", ResponseHeader.class);
            ByteString serverNonce = decoder.readByteString("ServerNonce");
            StatusCode[] results = decoder.readArray("Results", decoder::readStatusCode, StatusCode.class);
            DiagnosticInfo[] diagnosticInfos = decoder.readArray("DiagnosticInfos", decoder::readDiagnosticInfo, DiagnosticInfo.class);
            return new ActivateSessionResponse(responseHeader, serverNonce, results, diagnosticInfos);
        }

        @Override
        public void encode(ActivateSessionResponse value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStruct("ResponseHeader", value.responseHeader, ResponseHeader.class);
            encoder.writeByteString("ServerNonce", value.serverNonce);
            encoder.writeArray("Results", value.results, encoder::writeStatusCode);
            encoder.writeArray("DiagnosticInfos", value.diagnosticInfos, encoder::writeDiagnosticInfo);
        }
    }
}

