/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.AddReferencesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;

public class AddReferencesRequest
implements UaRequestMessage {
    public static final NodeId TypeId = Identifiers.AddReferencesRequest;
    public static final NodeId BinaryEncodingId = Identifiers.AddReferencesRequest_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.AddReferencesRequest_Encoding_DefaultXml;
    protected final RequestHeader requestHeader;
    protected final AddReferencesItem[] referencesToAdd;

    public AddReferencesRequest() {
        this.requestHeader = null;
        this.referencesToAdd = null;
    }

    public AddReferencesRequest(RequestHeader requestHeader, AddReferencesItem[] referencesToAdd) {
        this.requestHeader = requestHeader;
        this.referencesToAdd = referencesToAdd;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    @Nullable
    public AddReferencesItem[] getReferencesToAdd() {
        return this.referencesToAdd;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("RequestHeader", (Object)this.requestHeader).add("ReferencesToAdd", (Object)this.referencesToAdd).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<AddReferencesRequest> {
        @Override
        public Class<AddReferencesRequest> getType() {
            return AddReferencesRequest.class;
        }

        @Override
        public AddReferencesRequest decode(UaDecoder decoder) throws UaSerializationException {
            RequestHeader requestHeader = decoder.readBuiltinStruct("RequestHeader", RequestHeader.class);
            AddReferencesItem[] referencesToAdd = (AddReferencesItem[])decoder.readBuiltinStructArray("ReferencesToAdd", AddReferencesItem.class);
            return new AddReferencesRequest(requestHeader, referencesToAdd);
        }

        @Override
        public void encode(AddReferencesRequest value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStruct("RequestHeader", value.requestHeader, RequestHeader.class);
            encoder.writeBuiltinStructArray("ReferencesToAdd", value.referencesToAdd, AddReferencesItem.class);
        }
    }
}

