/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.enumerated.AxisScaleEnumeration;
import org.eclipse.milo.opcua.stack.core.types.structured.EUInformation;
import org.eclipse.milo.opcua.stack.core.types.structured.Range;

public class AxisInformation
implements UaStructure {
    public static final NodeId TypeId = Identifiers.AxisInformation;
    public static final NodeId BinaryEncodingId = Identifiers.AxisInformation_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.AxisInformation_Encoding_DefaultXml;
    protected final EUInformation engineeringUnits;
    protected final Range eURange;
    protected final LocalizedText title;
    protected final AxisScaleEnumeration axisScaleType;
    protected final Double[] axisSteps;

    public AxisInformation() {
        this.engineeringUnits = null;
        this.eURange = null;
        this.title = null;
        this.axisScaleType = null;
        this.axisSteps = null;
    }

    public AxisInformation(EUInformation engineeringUnits, Range eURange, LocalizedText title, AxisScaleEnumeration axisScaleType, Double[] axisSteps) {
        this.engineeringUnits = engineeringUnits;
        this.eURange = eURange;
        this.title = title;
        this.axisScaleType = axisScaleType;
        this.axisSteps = axisSteps;
    }

    public EUInformation getEngineeringUnits() {
        return this.engineeringUnits;
    }

    public Range getEURange() {
        return this.eURange;
    }

    public LocalizedText getTitle() {
        return this.title;
    }

    public AxisScaleEnumeration getAxisScaleType() {
        return this.axisScaleType;
    }

    @Nullable
    public Double[] getAxisSteps() {
        return this.axisSteps;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("EngineeringUnits", (Object)this.engineeringUnits).add("EURange", (Object)this.eURange).add("Title", (Object)this.title).add("AxisScaleType", (Object)this.axisScaleType).add("AxisSteps", (Object)this.axisSteps).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<AxisInformation> {
        @Override
        public Class<AxisInformation> getType() {
            return AxisInformation.class;
        }

        @Override
        public AxisInformation decode(UaDecoder decoder) throws UaSerializationException {
            EUInformation engineeringUnits = decoder.readBuiltinStruct("EngineeringUnits", EUInformation.class);
            Range eURange = decoder.readBuiltinStruct("EURange", Range.class);
            LocalizedText title = decoder.readLocalizedText("Title");
            AxisScaleEnumeration axisScaleType = AxisScaleEnumeration.from(decoder.readInt32("AxisScaleType"));
            Double[] axisSteps = decoder.readArray("AxisSteps", decoder::readDouble, Double.class);
            return new AxisInformation(engineeringUnits, eURange, title, axisScaleType, axisSteps);
        }

        @Override
        public void encode(AxisInformation value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStruct("EngineeringUnits", value.engineeringUnits, EUInformation.class);
            encoder.writeBuiltinStruct("EURange", value.eURange, Range.class);
            encoder.writeLocalizedText("Title", value.title);
            encoder.writeInt32("AxisScaleType", value.axisScaleType != null ? value.axisScaleType.getValue() : 0);
            encoder.writeArray("AxisSteps", value.axisSteps, encoder::writeDouble);
        }
    }
}

