/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.RelativePath;

public class BrowsePath
implements UaStructure {
    public static final NodeId TypeId = Identifiers.BrowsePath;
    public static final NodeId BinaryEncodingId = Identifiers.BrowsePath_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.BrowsePath_Encoding_DefaultXml;
    protected final NodeId startingNode;
    protected final RelativePath relativePath;

    public BrowsePath() {
        this.startingNode = null;
        this.relativePath = null;
    }

    public BrowsePath(NodeId startingNode, RelativePath relativePath) {
        this.startingNode = startingNode;
        this.relativePath = relativePath;
    }

    public NodeId getStartingNode() {
        return this.startingNode;
    }

    public RelativePath getRelativePath() {
        return this.relativePath;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("StartingNode", (Object)this.startingNode).add("RelativePath", (Object)this.relativePath).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<BrowsePath> {
        @Override
        public Class<BrowsePath> getType() {
            return BrowsePath.class;
        }

        @Override
        public BrowsePath decode(UaDecoder decoder) throws UaSerializationException {
            NodeId startingNode = decoder.readNodeId("StartingNode");
            RelativePath relativePath = decoder.readBuiltinStruct("RelativePath", RelativePath.class);
            return new BrowsePath(startingNode, relativePath);
        }

        @Override
        public void encode(BrowsePath value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeNodeId("StartingNode", value.startingNode);
            encoder.writeBuiltinStruct("RelativePath", value.relativePath, RelativePath.class);
        }
    }
}

