/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowsePathTarget;

public class BrowsePathResult
implements UaStructure {
    public static final NodeId TypeId = Identifiers.BrowsePathResult;
    public static final NodeId BinaryEncodingId = Identifiers.BrowsePathResult_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.BrowsePathResult_Encoding_DefaultXml;
    protected final StatusCode statusCode;
    protected final BrowsePathTarget[] targets;

    public BrowsePathResult() {
        this.statusCode = null;
        this.targets = null;
    }

    public BrowsePathResult(StatusCode statusCode, BrowsePathTarget[] targets) {
        this.statusCode = statusCode;
        this.targets = targets;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    @Nullable
    public BrowsePathTarget[] getTargets() {
        return this.targets;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("StatusCode", (Object)this.statusCode).add("Targets", (Object)this.targets).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<BrowsePathResult> {
        @Override
        public Class<BrowsePathResult> getType() {
            return BrowsePathResult.class;
        }

        @Override
        public BrowsePathResult decode(UaDecoder decoder) throws UaSerializationException {
            StatusCode statusCode = decoder.readStatusCode("StatusCode");
            BrowsePathTarget[] targets = (BrowsePathTarget[])decoder.readBuiltinStructArray("Targets", BrowsePathTarget.class);
            return new BrowsePathResult(statusCode, targets);
        }

        @Override
        public void encode(BrowsePathResult value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeStatusCode("StatusCode", value.statusCode);
            encoder.writeBuiltinStructArray("Targets", value.targets, BrowsePathTarget.class);
        }
    }
}

