/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.ViewDescription;

public class BrowseRequest
implements UaRequestMessage {
    public static final NodeId TypeId = Identifiers.BrowseRequest;
    public static final NodeId BinaryEncodingId = Identifiers.BrowseRequest_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.BrowseRequest_Encoding_DefaultXml;
    protected final RequestHeader requestHeader;
    protected final ViewDescription view;
    protected final UInteger requestedMaxReferencesPerNode;
    protected final BrowseDescription[] nodesToBrowse;

    public BrowseRequest() {
        this.requestHeader = null;
        this.view = null;
        this.requestedMaxReferencesPerNode = null;
        this.nodesToBrowse = null;
    }

    public BrowseRequest(RequestHeader requestHeader, ViewDescription view, UInteger requestedMaxReferencesPerNode, BrowseDescription[] nodesToBrowse) {
        this.requestHeader = requestHeader;
        this.view = view;
        this.requestedMaxReferencesPerNode = requestedMaxReferencesPerNode;
        this.nodesToBrowse = nodesToBrowse;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public ViewDescription getView() {
        return this.view;
    }

    public UInteger getRequestedMaxReferencesPerNode() {
        return this.requestedMaxReferencesPerNode;
    }

    @Nullable
    public BrowseDescription[] getNodesToBrowse() {
        return this.nodesToBrowse;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("RequestHeader", (Object)this.requestHeader).add("View", (Object)this.view).add("RequestedMaxReferencesPerNode", (Object)this.requestedMaxReferencesPerNode).add("NodesToBrowse", (Object)this.nodesToBrowse).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<BrowseRequest> {
        @Override
        public Class<BrowseRequest> getType() {
            return BrowseRequest.class;
        }

        @Override
        public BrowseRequest decode(UaDecoder decoder) throws UaSerializationException {
            RequestHeader requestHeader = decoder.readBuiltinStruct("RequestHeader", RequestHeader.class);
            ViewDescription view = decoder.readBuiltinStruct("View", ViewDescription.class);
            UInteger requestedMaxReferencesPerNode = decoder.readUInt32("RequestedMaxReferencesPerNode");
            BrowseDescription[] nodesToBrowse = (BrowseDescription[])decoder.readBuiltinStructArray("NodesToBrowse", BrowseDescription.class);
            return new BrowseRequest(requestHeader, view, requestedMaxReferencesPerNode, nodesToBrowse);
        }

        @Override
        public void encode(BrowseRequest value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStruct("RequestHeader", value.requestHeader, RequestHeader.class);
            encoder.writeBuiltinStruct("View", value.view, ViewDescription.class);
            encoder.writeUInt32("RequestedMaxReferencesPerNode", value.requestedMaxReferencesPerNode);
            encoder.writeBuiltinStructArray("NodesToBrowse", value.nodesToBrowse, BrowseDescription.class);
        }
    }
}

