/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;

public class CancelResponse
implements UaResponseMessage {
    public static final NodeId TypeId = Identifiers.CancelResponse;
    public static final NodeId BinaryEncodingId = Identifiers.CancelResponse_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.CancelResponse_Encoding_DefaultXml;
    protected final ResponseHeader responseHeader;
    protected final UInteger cancelCount;

    public CancelResponse() {
        this.responseHeader = null;
        this.cancelCount = null;
    }

    public CancelResponse(ResponseHeader responseHeader, UInteger cancelCount) {
        this.responseHeader = responseHeader;
        this.cancelCount = cancelCount;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public UInteger getCancelCount() {
        return this.cancelCount;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ResponseHeader", (Object)this.responseHeader).add("CancelCount", (Object)this.cancelCount).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<CancelResponse> {
        @Override
        public Class<CancelResponse> getType() {
            return CancelResponse.class;
        }

        @Override
        public CancelResponse decode(UaDecoder decoder) throws UaSerializationException {
            ResponseHeader responseHeader = decoder.readBuiltinStruct("ResponseHeader", ResponseHeader.class);
            UInteger cancelCount = decoder.readUInt32("CancelCount");
            return new CancelResponse(responseHeader, cancelCount);
        }

        @Override
        public void encode(CancelResponse value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStruct("ResponseHeader", value.responseHeader, ResponseHeader.class);
            encoder.writeUInt32("CancelCount", value.cancelCount);
        }
    }
}

