/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemCreateRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;

public class CreateMonitoredItemsRequest
implements UaRequestMessage {
    public static final NodeId TypeId = Identifiers.CreateMonitoredItemsRequest;
    public static final NodeId BinaryEncodingId = Identifiers.CreateMonitoredItemsRequest_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.CreateMonitoredItemsRequest_Encoding_DefaultXml;
    protected final RequestHeader requestHeader;
    protected final UInteger subscriptionId;
    protected final TimestampsToReturn timestampsToReturn;
    protected final MonitoredItemCreateRequest[] itemsToCreate;

    public CreateMonitoredItemsRequest() {
        this.requestHeader = null;
        this.subscriptionId = null;
        this.timestampsToReturn = null;
        this.itemsToCreate = null;
    }

    public CreateMonitoredItemsRequest(RequestHeader requestHeader, UInteger subscriptionId, TimestampsToReturn timestampsToReturn, MonitoredItemCreateRequest[] itemsToCreate) {
        this.requestHeader = requestHeader;
        this.subscriptionId = subscriptionId;
        this.timestampsToReturn = timestampsToReturn;
        this.itemsToCreate = itemsToCreate;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public UInteger getSubscriptionId() {
        return this.subscriptionId;
    }

    public TimestampsToReturn getTimestampsToReturn() {
        return this.timestampsToReturn;
    }

    @Nullable
    public MonitoredItemCreateRequest[] getItemsToCreate() {
        return this.itemsToCreate;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("RequestHeader", (Object)this.requestHeader).add("SubscriptionId", (Object)this.subscriptionId).add("TimestampsToReturn", (Object)this.timestampsToReturn).add("ItemsToCreate", (Object)this.itemsToCreate).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<CreateMonitoredItemsRequest> {
        @Override
        public Class<CreateMonitoredItemsRequest> getType() {
            return CreateMonitoredItemsRequest.class;
        }

        @Override
        public CreateMonitoredItemsRequest decode(UaDecoder decoder) throws UaSerializationException {
            RequestHeader requestHeader = decoder.readBuiltinStruct("RequestHeader", RequestHeader.class);
            UInteger subscriptionId = decoder.readUInt32("SubscriptionId");
            TimestampsToReturn timestampsToReturn = TimestampsToReturn.from(decoder.readInt32("TimestampsToReturn"));
            MonitoredItemCreateRequest[] itemsToCreate = (MonitoredItemCreateRequest[])decoder.readBuiltinStructArray("ItemsToCreate", MonitoredItemCreateRequest.class);
            return new CreateMonitoredItemsRequest(requestHeader, subscriptionId, timestampsToReturn, itemsToCreate);
        }

        @Override
        public void encode(CreateMonitoredItemsRequest value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStruct("RequestHeader", value.requestHeader, RequestHeader.class);
            encoder.writeUInt32("SubscriptionId", value.subscriptionId);
            encoder.writeInt32("TimestampsToReturn", value.timestampsToReturn != null ? value.timestampsToReturn.getValue() : 0);
            encoder.writeBuiltinStructArray("ItemsToCreate", value.itemsToCreate, MonitoredItemCreateRequest.class);
        }
    }
}

