/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemNotification;
import org.eclipse.milo.opcua.stack.core.types.structured.NotificationData;

public class DataChangeNotification
extends NotificationData {
    public static final NodeId TypeId = Identifiers.DataChangeNotification;
    public static final NodeId BinaryEncodingId = Identifiers.DataChangeNotification_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.DataChangeNotification_Encoding_DefaultXml;
    protected final MonitoredItemNotification[] monitoredItems;
    protected final DiagnosticInfo[] diagnosticInfos;

    public DataChangeNotification() {
        this.monitoredItems = null;
        this.diagnosticInfos = null;
    }

    public DataChangeNotification(MonitoredItemNotification[] monitoredItems, DiagnosticInfo[] diagnosticInfos) {
        this.monitoredItems = monitoredItems;
        this.diagnosticInfos = diagnosticInfos;
    }

    @Nullable
    public MonitoredItemNotification[] getMonitoredItems() {
        return this.monitoredItems;
    }

    @Nullable
    public DiagnosticInfo[] getDiagnosticInfos() {
        return this.diagnosticInfos;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("MonitoredItems", (Object)this.monitoredItems).add("DiagnosticInfos", (Object)this.diagnosticInfos).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<DataChangeNotification> {
        @Override
        public Class<DataChangeNotification> getType() {
            return DataChangeNotification.class;
        }

        @Override
        public DataChangeNotification decode(UaDecoder decoder) throws UaSerializationException {
            MonitoredItemNotification[] monitoredItems = (MonitoredItemNotification[])decoder.readBuiltinStructArray("MonitoredItems", MonitoredItemNotification.class);
            DiagnosticInfo[] diagnosticInfos = decoder.readArray("DiagnosticInfos", decoder::readDiagnosticInfo, DiagnosticInfo.class);
            return new DataChangeNotification(monitoredItems, diagnosticInfos);
        }

        @Override
        public void encode(DataChangeNotification value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStructArray("MonitoredItems", value.monitoredItems, MonitoredItemNotification.class);
            encoder.writeArray("DiagnosticInfos", value.diagnosticInfos, encoder::writeDiagnosticInfo);
        }
    }
}

