/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

public class DeleteNodesItem
implements UaStructure {
    public static final NodeId TypeId = Identifiers.DeleteNodesItem;
    public static final NodeId BinaryEncodingId = Identifiers.DeleteNodesItem_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.DeleteNodesItem_Encoding_DefaultXml;
    protected final NodeId nodeId;
    protected final Boolean deleteTargetReferences;

    public DeleteNodesItem() {
        this.nodeId = null;
        this.deleteTargetReferences = null;
    }

    public DeleteNodesItem(NodeId nodeId, Boolean deleteTargetReferences) {
        this.nodeId = nodeId;
        this.deleteTargetReferences = deleteTargetReferences;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public Boolean getDeleteTargetReferences() {
        return this.deleteTargetReferences;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("NodeId", (Object)this.nodeId).add("DeleteTargetReferences", (Object)this.deleteTargetReferences).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<DeleteNodesItem> {
        @Override
        public Class<DeleteNodesItem> getType() {
            return DeleteNodesItem.class;
        }

        @Override
        public DeleteNodesItem decode(UaDecoder decoder) throws UaSerializationException {
            NodeId nodeId = decoder.readNodeId("NodeId");
            Boolean deleteTargetReferences = decoder.readBoolean("DeleteTargetReferences");
            return new DeleteNodesItem(nodeId, deleteTargetReferences);
        }

        @Override
        public void encode(DeleteNodesItem value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeNodeId("NodeId", value.nodeId);
            encoder.writeBoolean("DeleteTargetReferences", value.deleteTargetReferences);
        }
    }
}

