/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteReferencesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;

public class DeleteReferencesRequest
implements UaRequestMessage {
    public static final NodeId TypeId = Identifiers.DeleteReferencesRequest;
    public static final NodeId BinaryEncodingId = Identifiers.DeleteReferencesRequest_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.DeleteReferencesRequest_Encoding_DefaultXml;
    protected final RequestHeader requestHeader;
    protected final DeleteReferencesItem[] referencesToDelete;

    public DeleteReferencesRequest() {
        this.requestHeader = null;
        this.referencesToDelete = null;
    }

    public DeleteReferencesRequest(RequestHeader requestHeader, DeleteReferencesItem[] referencesToDelete) {
        this.requestHeader = requestHeader;
        this.referencesToDelete = referencesToDelete;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    @Nullable
    public DeleteReferencesItem[] getReferencesToDelete() {
        return this.referencesToDelete;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("RequestHeader", (Object)this.requestHeader).add("ReferencesToDelete", (Object)this.referencesToDelete).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<DeleteReferencesRequest> {
        @Override
        public Class<DeleteReferencesRequest> getType() {
            return DeleteReferencesRequest.class;
        }

        @Override
        public DeleteReferencesRequest decode(UaDecoder decoder) throws UaSerializationException {
            RequestHeader requestHeader = decoder.readBuiltinStruct("RequestHeader", RequestHeader.class);
            DeleteReferencesItem[] referencesToDelete = (DeleteReferencesItem[])decoder.readBuiltinStructArray("ReferencesToDelete", DeleteReferencesItem.class);
            return new DeleteReferencesRequest(requestHeader, referencesToDelete);
        }

        @Override
        public void encode(DeleteReferencesRequest value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStruct("RequestHeader", value.requestHeader, RequestHeader.class);
            encoder.writeBuiltinStructArray("ReferencesToDelete", value.referencesToDelete, DeleteReferencesItem.class);
        }
    }
}

