/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.ServerOnNetwork;

public class FindServersOnNetworkResponse
implements UaResponseMessage {
    public static final NodeId TypeId = Identifiers.FindServersOnNetworkResponse;
    public static final NodeId BinaryEncodingId = Identifiers.FindServersOnNetworkResponse_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.FindServersOnNetworkResponse_Encoding_DefaultXml;
    protected final ResponseHeader responseHeader;
    protected final DateTime lastCounterResetTime;
    protected final ServerOnNetwork[] servers;

    public FindServersOnNetworkResponse() {
        this.responseHeader = null;
        this.lastCounterResetTime = null;
        this.servers = null;
    }

    public FindServersOnNetworkResponse(ResponseHeader responseHeader, DateTime lastCounterResetTime, ServerOnNetwork[] servers) {
        this.responseHeader = responseHeader;
        this.lastCounterResetTime = lastCounterResetTime;
        this.servers = servers;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public DateTime getLastCounterResetTime() {
        return this.lastCounterResetTime;
    }

    @Nullable
    public ServerOnNetwork[] getServers() {
        return this.servers;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ResponseHeader", (Object)this.responseHeader).add("LastCounterResetTime", (Object)this.lastCounterResetTime).add("Servers", (Object)this.servers).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<FindServersOnNetworkResponse> {
        @Override
        public Class<FindServersOnNetworkResponse> getType() {
            return FindServersOnNetworkResponse.class;
        }

        @Override
        public FindServersOnNetworkResponse decode(UaDecoder decoder) throws UaSerializationException {
            ResponseHeader responseHeader = decoder.readBuiltinStruct("ResponseHeader", ResponseHeader.class);
            DateTime lastCounterResetTime = decoder.readDateTime("LastCounterResetTime");
            ServerOnNetwork[] servers = (ServerOnNetwork[])decoder.readBuiltinStructArray("Servers", ServerOnNetwork.class);
            return new FindServersOnNetworkResponse(responseHeader, lastCounterResetTime, servers);
        }

        @Override
        public void encode(FindServersOnNetworkResponse value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStruct("ResponseHeader", value.responseHeader, ResponseHeader.class);
            encoder.writeDateTime("LastCounterResetTime", value.lastCounterResetTime);
            encoder.writeBuiltinStructArray("Servers", value.servers, ServerOnNetwork.class);
        }
    }
}

