/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryEventFieldList;

public class HistoryEvent
implements UaStructure {
    public static final NodeId TypeId = Identifiers.HistoryEvent;
    public static final NodeId BinaryEncodingId = Identifiers.HistoryEvent_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.HistoryEvent_Encoding_DefaultXml;
    protected final HistoryEventFieldList[] events;

    public HistoryEvent() {
        this.events = null;
    }

    public HistoryEvent(HistoryEventFieldList[] events) {
        this.events = events;
    }

    @Nullable
    public HistoryEventFieldList[] getEvents() {
        return this.events;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Events", (Object)this.events).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<HistoryEvent> {
        @Override
        public Class<HistoryEvent> getType() {
            return HistoryEvent.class;
        }

        @Override
        public HistoryEvent decode(UaDecoder decoder) throws UaSerializationException {
            HistoryEventFieldList[] events = (HistoryEventFieldList[])decoder.readBuiltinStructArray("Events", HistoryEventFieldList.class);
            return new HistoryEvent(events);
        }

        @Override
        public void encode(HistoryEvent value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStructArray("Events", value.events, HistoryEventFieldList.class);
        }
    }
}

