/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;

public class HistoryReadRequest
implements UaRequestMessage {
    public static final NodeId TypeId = Identifiers.HistoryReadRequest;
    public static final NodeId BinaryEncodingId = Identifiers.HistoryReadRequest_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.HistoryReadRequest_Encoding_DefaultXml;
    protected final RequestHeader requestHeader;
    protected final ExtensionObject historyReadDetails;
    protected final TimestampsToReturn timestampsToReturn;
    protected final Boolean releaseContinuationPoints;
    protected final HistoryReadValueId[] nodesToRead;

    public HistoryReadRequest() {
        this.requestHeader = null;
        this.historyReadDetails = null;
        this.timestampsToReturn = null;
        this.releaseContinuationPoints = null;
        this.nodesToRead = null;
    }

    public HistoryReadRequest(RequestHeader requestHeader, ExtensionObject historyReadDetails, TimestampsToReturn timestampsToReturn, Boolean releaseContinuationPoints, HistoryReadValueId[] nodesToRead) {
        this.requestHeader = requestHeader;
        this.historyReadDetails = historyReadDetails;
        this.timestampsToReturn = timestampsToReturn;
        this.releaseContinuationPoints = releaseContinuationPoints;
        this.nodesToRead = nodesToRead;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public ExtensionObject getHistoryReadDetails() {
        return this.historyReadDetails;
    }

    public TimestampsToReturn getTimestampsToReturn() {
        return this.timestampsToReturn;
    }

    public Boolean getReleaseContinuationPoints() {
        return this.releaseContinuationPoints;
    }

    @Nullable
    public HistoryReadValueId[] getNodesToRead() {
        return this.nodesToRead;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("RequestHeader", (Object)this.requestHeader).add("HistoryReadDetails", (Object)this.historyReadDetails).add("TimestampsToReturn", (Object)this.timestampsToReturn).add("ReleaseContinuationPoints", (Object)this.releaseContinuationPoints).add("NodesToRead", (Object)this.nodesToRead).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<HistoryReadRequest> {
        @Override
        public Class<HistoryReadRequest> getType() {
            return HistoryReadRequest.class;
        }

        @Override
        public HistoryReadRequest decode(UaDecoder decoder) throws UaSerializationException {
            RequestHeader requestHeader = decoder.readBuiltinStruct("RequestHeader", RequestHeader.class);
            ExtensionObject historyReadDetails = decoder.readExtensionObject("HistoryReadDetails");
            TimestampsToReturn timestampsToReturn = TimestampsToReturn.from(decoder.readInt32("TimestampsToReturn"));
            Boolean releaseContinuationPoints = decoder.readBoolean("ReleaseContinuationPoints");
            HistoryReadValueId[] nodesToRead = (HistoryReadValueId[])decoder.readBuiltinStructArray("NodesToRead", HistoryReadValueId.class);
            return new HistoryReadRequest(requestHeader, historyReadDetails, timestampsToReturn, releaseContinuationPoints, nodesToRead);
        }

        @Override
        public void encode(HistoryReadRequest value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStruct("RequestHeader", value.requestHeader, RequestHeader.class);
            encoder.writeExtensionObject("HistoryReadDetails", value.historyReadDetails);
            encoder.writeInt32("TimestampsToReturn", value.timestampsToReturn != null ? value.timestampsToReturn.getValue() : 0);
            encoder.writeBoolean("ReleaseContinuationPoints", value.releaseContinuationPoints);
            encoder.writeBuiltinStructArray("NodesToRead", value.nodesToRead, HistoryReadValueId.class);
        }
    }
}

