/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.UserIdentityToken;

public class KerberosIdentityToken
extends UserIdentityToken {
    public static final NodeId TypeId = Identifiers.KerberosIdentityToken;
    public static final NodeId BinaryEncodingId = Identifiers.KerberosIdentityToken_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.KerberosIdentityToken_Encoding_DefaultXml;
    protected final ByteString ticketData;

    public KerberosIdentityToken() {
        super(null);
        this.ticketData = null;
    }

    public KerberosIdentityToken(String policyId, ByteString ticketData) {
        super(policyId);
        this.ticketData = ticketData;
    }

    public ByteString getTicketData() {
        return this.ticketData;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("PolicyId", (Object)this.policyId).add("TicketData", (Object)this.ticketData).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<KerberosIdentityToken> {
        @Override
        public Class<KerberosIdentityToken> getType() {
            return KerberosIdentityToken.class;
        }

        @Override
        public KerberosIdentityToken decode(UaDecoder decoder) throws UaSerializationException {
            String policyId = decoder.readString("PolicyId");
            ByteString ticketData = decoder.readByteString("TicketData");
            return new KerberosIdentityToken(policyId, ticketData);
        }

        @Override
        public void encode(KerberosIdentityToken value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeString("PolicyId", value.policyId);
            encoder.writeByteString("TicketData", value.ticketData);
        }
    }
}

