/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.InstanceNode;
import org.eclipse.milo.opcua.stack.core.types.structured.ReferenceNode;

public class MethodNode
extends InstanceNode {
    public static final NodeId TypeId = Identifiers.MethodNode;
    public static final NodeId BinaryEncodingId = Identifiers.MethodNode_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.MethodNode_Encoding_DefaultXml;
    protected final Boolean executable;
    protected final Boolean userExecutable;

    public MethodNode() {
        super(null, null, null, null, null, null, null, null);
        this.executable = null;
        this.userExecutable = null;
    }

    public MethodNode(NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, ReferenceNode[] references, Boolean executable, Boolean userExecutable) {
        super(nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, references);
        this.executable = executable;
        this.userExecutable = userExecutable;
    }

    public Boolean getExecutable() {
        return this.executable;
    }

    public Boolean getUserExecutable() {
        return this.userExecutable;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("NodeId", (Object)this.nodeId).add("NodeClass", (Object)this.nodeClass).add("BrowseName", (Object)this.browseName).add("DisplayName", (Object)this.displayName).add("Description", (Object)this.description).add("WriteMask", (Object)this.writeMask).add("UserWriteMask", (Object)this.userWriteMask).add("References", (Object)this.references).add("Executable", (Object)this.executable).add("UserExecutable", (Object)this.userExecutable).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<MethodNode> {
        @Override
        public Class<MethodNode> getType() {
            return MethodNode.class;
        }

        @Override
        public MethodNode decode(UaDecoder decoder) throws UaSerializationException {
            NodeId nodeId = decoder.readNodeId("NodeId");
            NodeClass nodeClass = NodeClass.from(decoder.readInt32("NodeClass"));
            QualifiedName browseName = decoder.readQualifiedName("BrowseName");
            LocalizedText displayName = decoder.readLocalizedText("DisplayName");
            LocalizedText description = decoder.readLocalizedText("Description");
            UInteger writeMask = decoder.readUInt32("WriteMask");
            UInteger userWriteMask = decoder.readUInt32("UserWriteMask");
            ReferenceNode[] references = (ReferenceNode[])decoder.readBuiltinStructArray("References", ReferenceNode.class);
            Boolean executable = decoder.readBoolean("Executable");
            Boolean userExecutable = decoder.readBoolean("UserExecutable");
            return new MethodNode(nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, references, executable, userExecutable);
        }

        @Override
        public void encode(MethodNode value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeNodeId("NodeId", value.nodeId);
            encoder.writeInt32("NodeClass", value.nodeClass != null ? value.nodeClass.getValue() : 0);
            encoder.writeQualifiedName("BrowseName", value.browseName);
            encoder.writeLocalizedText("DisplayName", value.displayName);
            encoder.writeLocalizedText("Description", value.description);
            encoder.writeUInt32("WriteMask", value.writeMask);
            encoder.writeUInt32("UserWriteMask", value.userWriteMask);
            encoder.writeBuiltinStructArray("References", value.references, ReferenceNode.class);
            encoder.writeBoolean("Executable", value.executable);
            encoder.writeBoolean("UserExecutable", value.userExecutable);
        }
    }
}

