/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MonitoringMode;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringParameters;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;

public class MonitoredItemCreateRequest
implements UaStructure {
    public static final NodeId TypeId = Identifiers.MonitoredItemCreateRequest;
    public static final NodeId BinaryEncodingId = Identifiers.MonitoredItemCreateRequest_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.MonitoredItemCreateRequest_Encoding_DefaultXml;
    protected final ReadValueId itemToMonitor;
    protected final MonitoringMode monitoringMode;
    protected final MonitoringParameters requestedParameters;

    public MonitoredItemCreateRequest() {
        this.itemToMonitor = null;
        this.monitoringMode = null;
        this.requestedParameters = null;
    }

    public MonitoredItemCreateRequest(ReadValueId itemToMonitor, MonitoringMode monitoringMode, MonitoringParameters requestedParameters) {
        this.itemToMonitor = itemToMonitor;
        this.monitoringMode = monitoringMode;
        this.requestedParameters = requestedParameters;
    }

    public ReadValueId getItemToMonitor() {
        return this.itemToMonitor;
    }

    public MonitoringMode getMonitoringMode() {
        return this.monitoringMode;
    }

    public MonitoringParameters getRequestedParameters() {
        return this.requestedParameters;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ItemToMonitor", (Object)this.itemToMonitor).add("MonitoringMode", (Object)this.monitoringMode).add("RequestedParameters", (Object)this.requestedParameters).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<MonitoredItemCreateRequest> {
        @Override
        public Class<MonitoredItemCreateRequest> getType() {
            return MonitoredItemCreateRequest.class;
        }

        @Override
        public MonitoredItemCreateRequest decode(UaDecoder decoder) throws UaSerializationException {
            ReadValueId itemToMonitor = decoder.readBuiltinStruct("ItemToMonitor", ReadValueId.class);
            MonitoringMode monitoringMode = MonitoringMode.from(decoder.readInt32("MonitoringMode"));
            MonitoringParameters requestedParameters = decoder.readBuiltinStruct("RequestedParameters", MonitoringParameters.class);
            return new MonitoredItemCreateRequest(itemToMonitor, monitoringMode, requestedParameters);
        }

        @Override
        public void encode(MonitoredItemCreateRequest value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStruct("ItemToMonitor", value.itemToMonitor, ReadValueId.class);
            encoder.writeInt32("MonitoringMode", value.monitoringMode != null ? value.monitoringMode.getValue() : 0);
            encoder.writeBuiltinStruct("RequestedParameters", value.requestedParameters, MonitoringParameters.class);
        }
    }
}

