/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointUrlListDataType;

public class NetworkGroupDataType
implements UaStructure {
    public static final NodeId TypeId = Identifiers.NetworkGroupDataType;
    public static final NodeId BinaryEncodingId = Identifiers.NetworkGroupDataType_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.NetworkGroupDataType_Encoding_DefaultXml;
    protected final String serverUri;
    protected final EndpointUrlListDataType[] networkPaths;

    public NetworkGroupDataType() {
        this.serverUri = null;
        this.networkPaths = null;
    }

    public NetworkGroupDataType(String serverUri, EndpointUrlListDataType[] networkPaths) {
        this.serverUri = serverUri;
        this.networkPaths = networkPaths;
    }

    public String getServerUri() {
        return this.serverUri;
    }

    @Nullable
    public EndpointUrlListDataType[] getNetworkPaths() {
        return this.networkPaths;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ServerUri", (Object)this.serverUri).add("NetworkPaths", (Object)this.networkPaths).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<NetworkGroupDataType> {
        @Override
        public Class<NetworkGroupDataType> getType() {
            return NetworkGroupDataType.class;
        }

        @Override
        public NetworkGroupDataType decode(UaDecoder decoder) throws UaSerializationException {
            String serverUri = decoder.readString("ServerUri");
            EndpointUrlListDataType[] networkPaths = (EndpointUrlListDataType[])decoder.readBuiltinStructArray("NetworkPaths", EndpointUrlListDataType.class);
            return new NetworkGroupDataType(serverUri, networkPaths);
        }

        @Override
        public void encode(NetworkGroupDataType value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeString("ServerUri", value.serverUri);
            encoder.writeBuiltinStructArray("NetworkPaths", value.networkPaths, EndpointUrlListDataType.class);
        }
    }
}

