/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.SecurityTokenRequestType;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;

public class OpenSecureChannelRequest
implements UaRequestMessage {
    public static final NodeId TypeId = Identifiers.OpenSecureChannelRequest;
    public static final NodeId BinaryEncodingId = Identifiers.OpenSecureChannelRequest_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.OpenSecureChannelRequest_Encoding_DefaultXml;
    protected final RequestHeader requestHeader;
    protected final UInteger clientProtocolVersion;
    protected final SecurityTokenRequestType requestType;
    protected final MessageSecurityMode securityMode;
    protected final ByteString clientNonce;
    protected final UInteger requestedLifetime;

    public OpenSecureChannelRequest() {
        this.requestHeader = null;
        this.clientProtocolVersion = null;
        this.requestType = null;
        this.securityMode = null;
        this.clientNonce = null;
        this.requestedLifetime = null;
    }

    public OpenSecureChannelRequest(RequestHeader requestHeader, UInteger clientProtocolVersion, SecurityTokenRequestType requestType, MessageSecurityMode securityMode, ByteString clientNonce, UInteger requestedLifetime) {
        this.requestHeader = requestHeader;
        this.clientProtocolVersion = clientProtocolVersion;
        this.requestType = requestType;
        this.securityMode = securityMode;
        this.clientNonce = clientNonce;
        this.requestedLifetime = requestedLifetime;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public UInteger getClientProtocolVersion() {
        return this.clientProtocolVersion;
    }

    public SecurityTokenRequestType getRequestType() {
        return this.requestType;
    }

    public MessageSecurityMode getSecurityMode() {
        return this.securityMode;
    }

    public ByteString getClientNonce() {
        return this.clientNonce;
    }

    public UInteger getRequestedLifetime() {
        return this.requestedLifetime;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("RequestHeader", (Object)this.requestHeader).add("ClientProtocolVersion", (Object)this.clientProtocolVersion).add("RequestType", (Object)this.requestType).add("SecurityMode", (Object)this.securityMode).add("ClientNonce", (Object)this.clientNonce).add("RequestedLifetime", (Object)this.requestedLifetime).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<OpenSecureChannelRequest> {
        @Override
        public Class<OpenSecureChannelRequest> getType() {
            return OpenSecureChannelRequest.class;
        }

        @Override
        public OpenSecureChannelRequest decode(UaDecoder decoder) throws UaSerializationException {
            RequestHeader requestHeader = decoder.readBuiltinStruct("RequestHeader", RequestHeader.class);
            UInteger clientProtocolVersion = decoder.readUInt32("ClientProtocolVersion");
            SecurityTokenRequestType requestType = SecurityTokenRequestType.from(decoder.readInt32("RequestType"));
            MessageSecurityMode securityMode = MessageSecurityMode.from(decoder.readInt32("SecurityMode"));
            ByteString clientNonce = decoder.readByteString("ClientNonce");
            UInteger requestedLifetime = decoder.readUInt32("RequestedLifetime");
            return new OpenSecureChannelRequest(requestHeader, clientProtocolVersion, requestType, securityMode, clientNonce, requestedLifetime);
        }

        @Override
        public void encode(OpenSecureChannelRequest value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStruct("RequestHeader", value.requestHeader, RequestHeader.class);
            encoder.writeUInt32("ClientProtocolVersion", value.clientProtocolVersion);
            encoder.writeInt32("RequestType", value.requestType != null ? value.requestType.getValue() : 0);
            encoder.writeInt32("SecurityMode", value.securityMode != null ? value.securityMode.getValue() : 0);
            encoder.writeByteString("ClientNonce", value.clientNonce);
            encoder.writeUInt32("RequestedLifetime", value.requestedLifetime);
        }
    }
}

