/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;

public class ParsingResult
implements UaStructure {
    public static final NodeId TypeId = Identifiers.ParsingResult;
    public static final NodeId BinaryEncodingId = Identifiers.ParsingResult_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.ParsingResult_Encoding_DefaultXml;
    protected final StatusCode statusCode;
    protected final StatusCode[] dataStatusCodes;
    protected final DiagnosticInfo[] dataDiagnosticInfos;

    public ParsingResult() {
        this.statusCode = null;
        this.dataStatusCodes = null;
        this.dataDiagnosticInfos = null;
    }

    public ParsingResult(StatusCode statusCode, StatusCode[] dataStatusCodes, DiagnosticInfo[] dataDiagnosticInfos) {
        this.statusCode = statusCode;
        this.dataStatusCodes = dataStatusCodes;
        this.dataDiagnosticInfos = dataDiagnosticInfos;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    @Nullable
    public StatusCode[] getDataStatusCodes() {
        return this.dataStatusCodes;
    }

    @Nullable
    public DiagnosticInfo[] getDataDiagnosticInfos() {
        return this.dataDiagnosticInfos;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("StatusCode", (Object)this.statusCode).add("DataStatusCodes", (Object)this.dataStatusCodes).add("DataDiagnosticInfos", (Object)this.dataDiagnosticInfos).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<ParsingResult> {
        @Override
        public Class<ParsingResult> getType() {
            return ParsingResult.class;
        }

        @Override
        public ParsingResult decode(UaDecoder decoder) throws UaSerializationException {
            StatusCode statusCode = decoder.readStatusCode("StatusCode");
            StatusCode[] dataStatusCodes = decoder.readArray("DataStatusCodes", decoder::readStatusCode, StatusCode.class);
            DiagnosticInfo[] dataDiagnosticInfos = decoder.readArray("DataDiagnosticInfos", decoder::readDiagnosticInfo, DiagnosticInfo.class);
            return new ParsingResult(statusCode, dataStatusCodes, dataDiagnosticInfos);
        }

        @Override
        public void encode(ParsingResult value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeStatusCode("StatusCode", value.statusCode);
            encoder.writeArray("DataStatusCodes", value.dataStatusCodes, encoder::writeStatusCode);
            encoder.writeArray("DataDiagnosticInfos", value.dataDiagnosticInfos, encoder::writeDiagnosticInfo);
        }
    }
}

