/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.SubscriptionAcknowledgement;

public class PublishRequest
implements UaRequestMessage {
    public static final NodeId TypeId = Identifiers.PublishRequest;
    public static final NodeId BinaryEncodingId = Identifiers.PublishRequest_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.PublishRequest_Encoding_DefaultXml;
    protected final RequestHeader requestHeader;
    protected final SubscriptionAcknowledgement[] subscriptionAcknowledgements;

    public PublishRequest() {
        this.requestHeader = null;
        this.subscriptionAcknowledgements = null;
    }

    public PublishRequest(RequestHeader requestHeader, SubscriptionAcknowledgement[] subscriptionAcknowledgements) {
        this.requestHeader = requestHeader;
        this.subscriptionAcknowledgements = subscriptionAcknowledgements;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    @Nullable
    public SubscriptionAcknowledgement[] getSubscriptionAcknowledgements() {
        return this.subscriptionAcknowledgements;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("RequestHeader", (Object)this.requestHeader).add("SubscriptionAcknowledgements", (Object)this.subscriptionAcknowledgements).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<PublishRequest> {
        @Override
        public Class<PublishRequest> getType() {
            return PublishRequest.class;
        }

        @Override
        public PublishRequest decode(UaDecoder decoder) throws UaSerializationException {
            RequestHeader requestHeader = decoder.readBuiltinStruct("RequestHeader", RequestHeader.class);
            SubscriptionAcknowledgement[] subscriptionAcknowledgements = (SubscriptionAcknowledgement[])decoder.readBuiltinStructArray("SubscriptionAcknowledgements", SubscriptionAcknowledgement.class);
            return new PublishRequest(requestHeader, subscriptionAcknowledgements);
        }

        @Override
        public void encode(PublishRequest value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStruct("RequestHeader", value.requestHeader, RequestHeader.class);
            encoder.writeBuiltinStructArray("SubscriptionAcknowledgements", value.subscriptionAcknowledgements, SubscriptionAcknowledgement.class);
        }
    }
}

