/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilterResult;
import org.eclipse.milo.opcua.stack.core.types.structured.ParsingResult;
import org.eclipse.milo.opcua.stack.core.types.structured.QueryDataSet;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;

public class QueryFirstResponse
implements UaResponseMessage {
    public static final NodeId TypeId = Identifiers.QueryFirstResponse;
    public static final NodeId BinaryEncodingId = Identifiers.QueryFirstResponse_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.QueryFirstResponse_Encoding_DefaultXml;
    protected final ResponseHeader responseHeader;
    protected final QueryDataSet[] queryDataSets;
    protected final ByteString continuationPoint;
    protected final ParsingResult[] parsingResults;
    protected final DiagnosticInfo[] diagnosticInfos;
    protected final ContentFilterResult filterResult;

    public QueryFirstResponse() {
        this.responseHeader = null;
        this.queryDataSets = null;
        this.continuationPoint = null;
        this.parsingResults = null;
        this.diagnosticInfos = null;
        this.filterResult = null;
    }

    public QueryFirstResponse(ResponseHeader responseHeader, QueryDataSet[] queryDataSets, ByteString continuationPoint, ParsingResult[] parsingResults, DiagnosticInfo[] diagnosticInfos, ContentFilterResult filterResult) {
        this.responseHeader = responseHeader;
        this.queryDataSets = queryDataSets;
        this.continuationPoint = continuationPoint;
        this.parsingResults = parsingResults;
        this.diagnosticInfos = diagnosticInfos;
        this.filterResult = filterResult;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    @Nullable
    public QueryDataSet[] getQueryDataSets() {
        return this.queryDataSets;
    }

    public ByteString getContinuationPoint() {
        return this.continuationPoint;
    }

    @Nullable
    public ParsingResult[] getParsingResults() {
        return this.parsingResults;
    }

    @Nullable
    public DiagnosticInfo[] getDiagnosticInfos() {
        return this.diagnosticInfos;
    }

    public ContentFilterResult getFilterResult() {
        return this.filterResult;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ResponseHeader", (Object)this.responseHeader).add("QueryDataSets", (Object)this.queryDataSets).add("ContinuationPoint", (Object)this.continuationPoint).add("ParsingResults", (Object)this.parsingResults).add("DiagnosticInfos", (Object)this.diagnosticInfos).add("FilterResult", (Object)this.filterResult).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<QueryFirstResponse> {
        @Override
        public Class<QueryFirstResponse> getType() {
            return QueryFirstResponse.class;
        }

        @Override
        public QueryFirstResponse decode(UaDecoder decoder) throws UaSerializationException {
            ResponseHeader responseHeader = decoder.readBuiltinStruct("ResponseHeader", ResponseHeader.class);
            QueryDataSet[] queryDataSets = (QueryDataSet[])decoder.readBuiltinStructArray("QueryDataSets", QueryDataSet.class);
            ByteString continuationPoint = decoder.readByteString("ContinuationPoint");
            ParsingResult[] parsingResults = (ParsingResult[])decoder.readBuiltinStructArray("ParsingResults", ParsingResult.class);
            DiagnosticInfo[] diagnosticInfos = decoder.readArray("DiagnosticInfos", decoder::readDiagnosticInfo, DiagnosticInfo.class);
            ContentFilterResult filterResult = decoder.readBuiltinStruct("FilterResult", ContentFilterResult.class);
            return new QueryFirstResponse(responseHeader, queryDataSets, continuationPoint, parsingResults, diagnosticInfos, filterResult);
        }

        @Override
        public void encode(QueryFirstResponse value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStruct("ResponseHeader", value.responseHeader, ResponseHeader.class);
            encoder.writeBuiltinStructArray("QueryDataSets", value.queryDataSets, QueryDataSet.class);
            encoder.writeByteString("ContinuationPoint", value.continuationPoint);
            encoder.writeBuiltinStructArray("ParsingResults", value.parsingResults, ParsingResult.class);
            encoder.writeArray("DiagnosticInfos", value.diagnosticInfos, encoder::writeDiagnosticInfo);
            encoder.writeBuiltinStruct("FilterResult", value.filterResult, ContentFilterResult.class);
        }
    }
}

