/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadDetails;

public class ReadAtTimeDetails
extends HistoryReadDetails {
    public static final NodeId TypeId = Identifiers.ReadAtTimeDetails;
    public static final NodeId BinaryEncodingId = Identifiers.ReadAtTimeDetails_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.ReadAtTimeDetails_Encoding_DefaultXml;
    protected final DateTime[] reqTimes;
    protected final Boolean useSimpleBounds;

    public ReadAtTimeDetails() {
        this.reqTimes = null;
        this.useSimpleBounds = null;
    }

    public ReadAtTimeDetails(DateTime[] reqTimes, Boolean useSimpleBounds) {
        this.reqTimes = reqTimes;
        this.useSimpleBounds = useSimpleBounds;
    }

    @Nullable
    public DateTime[] getReqTimes() {
        return this.reqTimes;
    }

    public Boolean getUseSimpleBounds() {
        return this.useSimpleBounds;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ReqTimes", (Object)this.reqTimes).add("UseSimpleBounds", (Object)this.useSimpleBounds).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<ReadAtTimeDetails> {
        @Override
        public Class<ReadAtTimeDetails> getType() {
            return ReadAtTimeDetails.class;
        }

        @Override
        public ReadAtTimeDetails decode(UaDecoder decoder) throws UaSerializationException {
            DateTime[] reqTimes = decoder.readArray("ReqTimes", decoder::readDateTime, DateTime.class);
            Boolean useSimpleBounds = decoder.readBoolean("UseSimpleBounds");
            return new ReadAtTimeDetails(reqTimes, useSimpleBounds);
        }

        @Override
        public void encode(ReadAtTimeDetails value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeArray("ReqTimes", value.reqTimes, encoder::writeDateTime);
            encoder.writeBoolean("UseSimpleBounds", value.useSimpleBounds);
        }
    }
}

