/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.AggregateConfiguration;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadDetails;

public class ReadProcessedDetails
extends HistoryReadDetails {
    public static final NodeId TypeId = Identifiers.ReadProcessedDetails;
    public static final NodeId BinaryEncodingId = Identifiers.ReadProcessedDetails_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.ReadProcessedDetails_Encoding_DefaultXml;
    protected final DateTime startTime;
    protected final DateTime endTime;
    protected final Double processingInterval;
    protected final NodeId[] aggregateType;
    protected final AggregateConfiguration aggregateConfiguration;

    public ReadProcessedDetails() {
        this.startTime = null;
        this.endTime = null;
        this.processingInterval = null;
        this.aggregateType = null;
        this.aggregateConfiguration = null;
    }

    public ReadProcessedDetails(DateTime startTime, DateTime endTime, Double processingInterval, NodeId[] aggregateType, AggregateConfiguration aggregateConfiguration) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.processingInterval = processingInterval;
        this.aggregateType = aggregateType;
        this.aggregateConfiguration = aggregateConfiguration;
    }

    public DateTime getStartTime() {
        return this.startTime;
    }

    public DateTime getEndTime() {
        return this.endTime;
    }

    public Double getProcessingInterval() {
        return this.processingInterval;
    }

    @Nullable
    public NodeId[] getAggregateType() {
        return this.aggregateType;
    }

    public AggregateConfiguration getAggregateConfiguration() {
        return this.aggregateConfiguration;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("StartTime", (Object)this.startTime).add("EndTime", (Object)this.endTime).add("ProcessingInterval", (Object)this.processingInterval).add("AggregateType", (Object)this.aggregateType).add("AggregateConfiguration", (Object)this.aggregateConfiguration).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<ReadProcessedDetails> {
        @Override
        public Class<ReadProcessedDetails> getType() {
            return ReadProcessedDetails.class;
        }

        @Override
        public ReadProcessedDetails decode(UaDecoder decoder) throws UaSerializationException {
            DateTime startTime = decoder.readDateTime("StartTime");
            DateTime endTime = decoder.readDateTime("EndTime");
            Double processingInterval = decoder.readDouble("ProcessingInterval");
            NodeId[] aggregateType = decoder.readArray("AggregateType", decoder::readNodeId, NodeId.class);
            AggregateConfiguration aggregateConfiguration = decoder.readBuiltinStruct("AggregateConfiguration", AggregateConfiguration.class);
            return new ReadProcessedDetails(startTime, endTime, processingInterval, aggregateType, aggregateConfiguration);
        }

        @Override
        public void encode(ReadProcessedDetails value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeDateTime("StartTime", value.startTime);
            encoder.writeDateTime("EndTime", value.endTime);
            encoder.writeDouble("ProcessingInterval", value.processingInterval);
            encoder.writeArray("AggregateType", value.aggregateType, encoder::writeNodeId);
            encoder.writeBuiltinStruct("AggregateConfiguration", value.aggregateConfiguration, AggregateConfiguration.class);
        }
    }
}

