/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;

public class ReadRequest
implements UaRequestMessage {
    public static final NodeId TypeId = Identifiers.ReadRequest;
    public static final NodeId BinaryEncodingId = Identifiers.ReadRequest_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.ReadRequest_Encoding_DefaultXml;
    protected final RequestHeader requestHeader;
    protected final Double maxAge;
    protected final TimestampsToReturn timestampsToReturn;
    protected final ReadValueId[] nodesToRead;

    public ReadRequest() {
        this.requestHeader = null;
        this.maxAge = null;
        this.timestampsToReturn = null;
        this.nodesToRead = null;
    }

    public ReadRequest(RequestHeader requestHeader, Double maxAge, TimestampsToReturn timestampsToReturn, ReadValueId[] nodesToRead) {
        this.requestHeader = requestHeader;
        this.maxAge = maxAge;
        this.timestampsToReturn = timestampsToReturn;
        this.nodesToRead = nodesToRead;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public Double getMaxAge() {
        return this.maxAge;
    }

    public TimestampsToReturn getTimestampsToReturn() {
        return this.timestampsToReturn;
    }

    @Nullable
    public ReadValueId[] getNodesToRead() {
        return this.nodesToRead;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("RequestHeader", (Object)this.requestHeader).add("MaxAge", (Object)this.maxAge).add("TimestampsToReturn", (Object)this.timestampsToReturn).add("NodesToRead", (Object)this.nodesToRead).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<ReadRequest> {
        @Override
        public Class<ReadRequest> getType() {
            return ReadRequest.class;
        }

        @Override
        public ReadRequest decode(UaDecoder decoder) throws UaSerializationException {
            RequestHeader requestHeader = decoder.readBuiltinStruct("RequestHeader", RequestHeader.class);
            Double maxAge = decoder.readDouble("MaxAge");
            TimestampsToReturn timestampsToReturn = TimestampsToReturn.from(decoder.readInt32("TimestampsToReturn"));
            ReadValueId[] nodesToRead = (ReadValueId[])decoder.readBuiltinStructArray("NodesToRead", ReadValueId.class);
            return new ReadRequest(requestHeader, maxAge, timestampsToReturn, nodesToRead);
        }

        @Override
        public void encode(ReadRequest value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStruct("RequestHeader", value.requestHeader, RequestHeader.class);
            encoder.writeDouble("MaxAge", value.maxAge);
            encoder.writeInt32("TimestampsToReturn", value.timestampsToReturn != null ? value.timestampsToReturn.getValue() : 0);
            encoder.writeBuiltinStructArray("NodesToRead", value.nodesToRead, ReadValueId.class);
        }
    }
}

