/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

public class ReadValueId
implements UaStructure {
    public static final NodeId TypeId = Identifiers.ReadValueId;
    public static final NodeId BinaryEncodingId = Identifiers.ReadValueId_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.ReadValueId_Encoding_DefaultXml;
    protected final NodeId nodeId;
    protected final UInteger attributeId;
    protected final String indexRange;
    protected final QualifiedName dataEncoding;

    public ReadValueId() {
        this.nodeId = null;
        this.attributeId = null;
        this.indexRange = null;
        this.dataEncoding = null;
    }

    public ReadValueId(NodeId nodeId, UInteger attributeId, String indexRange, QualifiedName dataEncoding) {
        this.nodeId = nodeId;
        this.attributeId = attributeId;
        this.indexRange = indexRange;
        this.dataEncoding = dataEncoding;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public UInteger getAttributeId() {
        return this.attributeId;
    }

    public String getIndexRange() {
        return this.indexRange;
    }

    public QualifiedName getDataEncoding() {
        return this.dataEncoding;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("NodeId", (Object)this.nodeId).add("AttributeId", (Object)this.attributeId).add("IndexRange", (Object)this.indexRange).add("DataEncoding", (Object)this.dataEncoding).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<ReadValueId> {
        @Override
        public Class<ReadValueId> getType() {
            return ReadValueId.class;
        }

        @Override
        public ReadValueId decode(UaDecoder decoder) throws UaSerializationException {
            NodeId nodeId = decoder.readNodeId("NodeId");
            UInteger attributeId = decoder.readUInt32("AttributeId");
            String indexRange = decoder.readString("IndexRange");
            QualifiedName dataEncoding = decoder.readQualifiedName("DataEncoding");
            return new ReadValueId(nodeId, attributeId, indexRange, dataEncoding);
        }

        @Override
        public void encode(ReadValueId value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeNodeId("NodeId", value.nodeId);
            encoder.writeUInt32("AttributeId", value.attributeId);
            encoder.writeString("IndexRange", value.indexRange);
            encoder.writeQualifiedName("DataEncoding", value.dataEncoding);
        }
    }
}

