/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;

public class RelativePathElement
implements UaStructure {
    public static final NodeId TypeId = Identifiers.RelativePathElement;
    public static final NodeId BinaryEncodingId = Identifiers.RelativePathElement_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.RelativePathElement_Encoding_DefaultXml;
    protected final NodeId referenceTypeId;
    protected final Boolean isInverse;
    protected final Boolean includeSubtypes;
    protected final QualifiedName targetName;

    public RelativePathElement() {
        this.referenceTypeId = null;
        this.isInverse = null;
        this.includeSubtypes = null;
        this.targetName = null;
    }

    public RelativePathElement(NodeId referenceTypeId, Boolean isInverse, Boolean includeSubtypes, QualifiedName targetName) {
        this.referenceTypeId = referenceTypeId;
        this.isInverse = isInverse;
        this.includeSubtypes = includeSubtypes;
        this.targetName = targetName;
    }

    public NodeId getReferenceTypeId() {
        return this.referenceTypeId;
    }

    public Boolean getIsInverse() {
        return this.isInverse;
    }

    public Boolean getIncludeSubtypes() {
        return this.includeSubtypes;
    }

    public QualifiedName getTargetName() {
        return this.targetName;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ReferenceTypeId", (Object)this.referenceTypeId).add("IsInverse", (Object)this.isInverse).add("IncludeSubtypes", (Object)this.includeSubtypes).add("TargetName", (Object)this.targetName).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<RelativePathElement> {
        @Override
        public Class<RelativePathElement> getType() {
            return RelativePathElement.class;
        }

        @Override
        public RelativePathElement decode(UaDecoder decoder) throws UaSerializationException {
            NodeId referenceTypeId = decoder.readNodeId("ReferenceTypeId");
            Boolean isInverse = decoder.readBoolean("IsInverse");
            Boolean includeSubtypes = decoder.readBoolean("IncludeSubtypes");
            QualifiedName targetName = decoder.readQualifiedName("TargetName");
            return new RelativePathElement(referenceTypeId, isInverse, includeSubtypes, targetName);
        }

        @Override
        public void encode(RelativePathElement value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeNodeId("ReferenceTypeId", value.referenceTypeId);
            encoder.writeBoolean("IsInverse", value.isInverse);
            encoder.writeBoolean("IncludeSubtypes", value.includeSubtypes);
            encoder.writeQualifiedName("TargetName", value.targetName);
        }
    }
}

