/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.NotificationMessage;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;

public class RepublishResponse
implements UaResponseMessage {
    public static final NodeId TypeId = Identifiers.RepublishResponse;
    public static final NodeId BinaryEncodingId = Identifiers.RepublishResponse_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.RepublishResponse_Encoding_DefaultXml;
    protected final ResponseHeader responseHeader;
    protected final NotificationMessage notificationMessage;

    public RepublishResponse() {
        this.responseHeader = null;
        this.notificationMessage = null;
    }

    public RepublishResponse(ResponseHeader responseHeader, NotificationMessage notificationMessage) {
        this.responseHeader = responseHeader;
        this.notificationMessage = notificationMessage;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public NotificationMessage getNotificationMessage() {
        return this.notificationMessage;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ResponseHeader", (Object)this.responseHeader).add("NotificationMessage", (Object)this.notificationMessage).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<RepublishResponse> {
        @Override
        public Class<RepublishResponse> getType() {
            return RepublishResponse.class;
        }

        @Override
        public RepublishResponse decode(UaDecoder decoder) throws UaSerializationException {
            ResponseHeader responseHeader = decoder.readBuiltinStruct("ResponseHeader", ResponseHeader.class);
            NotificationMessage notificationMessage = decoder.readBuiltinStruct("NotificationMessage", NotificationMessage.class);
            return new RepublishResponse(responseHeader, notificationMessage);
        }

        @Override
        public void encode(RepublishResponse value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStruct("ResponseHeader", value.responseHeader, ResponseHeader.class);
            encoder.writeBuiltinStruct("NotificationMessage", value.notificationMessage, NotificationMessage.class);
        }
    }
}

