/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.ServerState;
import org.eclipse.milo.opcua.stack.core.types.structured.BuildInfo;

public class ServerStatusDataType
implements UaStructure {
    public static final NodeId TypeId = Identifiers.ServerStatusDataType;
    public static final NodeId BinaryEncodingId = Identifiers.ServerStatusDataType_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.ServerStatusDataType_Encoding_DefaultXml;
    protected final DateTime startTime;
    protected final DateTime currentTime;
    protected final ServerState state;
    protected final BuildInfo buildInfo;
    protected final UInteger secondsTillShutdown;
    protected final LocalizedText shutdownReason;

    public ServerStatusDataType() {
        this.startTime = null;
        this.currentTime = null;
        this.state = null;
        this.buildInfo = null;
        this.secondsTillShutdown = null;
        this.shutdownReason = null;
    }

    public ServerStatusDataType(DateTime startTime, DateTime currentTime, ServerState state, BuildInfo buildInfo, UInteger secondsTillShutdown, LocalizedText shutdownReason) {
        this.startTime = startTime;
        this.currentTime = currentTime;
        this.state = state;
        this.buildInfo = buildInfo;
        this.secondsTillShutdown = secondsTillShutdown;
        this.shutdownReason = shutdownReason;
    }

    public DateTime getStartTime() {
        return this.startTime;
    }

    public DateTime getCurrentTime() {
        return this.currentTime;
    }

    public ServerState getState() {
        return this.state;
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public UInteger getSecondsTillShutdown() {
        return this.secondsTillShutdown;
    }

    public LocalizedText getShutdownReason() {
        return this.shutdownReason;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("StartTime", (Object)this.startTime).add("CurrentTime", (Object)this.currentTime).add("State", (Object)this.state).add("BuildInfo", (Object)this.buildInfo).add("SecondsTillShutdown", (Object)this.secondsTillShutdown).add("ShutdownReason", (Object)this.shutdownReason).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<ServerStatusDataType> {
        @Override
        public Class<ServerStatusDataType> getType() {
            return ServerStatusDataType.class;
        }

        @Override
        public ServerStatusDataType decode(UaDecoder decoder) throws UaSerializationException {
            DateTime startTime = decoder.readDateTime("StartTime");
            DateTime currentTime = decoder.readDateTime("CurrentTime");
            ServerState state = ServerState.from(decoder.readInt32("State"));
            BuildInfo buildInfo = decoder.readBuiltinStruct("BuildInfo", BuildInfo.class);
            UInteger secondsTillShutdown = decoder.readUInt32("SecondsTillShutdown");
            LocalizedText shutdownReason = decoder.readLocalizedText("ShutdownReason");
            return new ServerStatusDataType(startTime, currentTime, state, buildInfo, secondsTillShutdown, shutdownReason);
        }

        @Override
        public void encode(ServerStatusDataType value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeDateTime("StartTime", value.startTime);
            encoder.writeDateTime("CurrentTime", value.currentTime);
            encoder.writeInt32("State", value.state != null ? value.state.getValue() : 0);
            encoder.writeBuiltinStruct("BuildInfo", value.buildInfo, BuildInfo.class);
            encoder.writeUInt32("SecondsTillShutdown", value.secondsTillShutdown);
            encoder.writeLocalizedText("ShutdownReason", value.shutdownReason);
        }
    }
}

