/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;

public class SetTriggeringRequest
implements UaRequestMessage {
    public static final NodeId TypeId = Identifiers.SetTriggeringRequest;
    public static final NodeId BinaryEncodingId = Identifiers.SetTriggeringRequest_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.SetTriggeringRequest_Encoding_DefaultXml;
    protected final RequestHeader requestHeader;
    protected final UInteger subscriptionId;
    protected final UInteger triggeringItemId;
    protected final UInteger[] linksToAdd;
    protected final UInteger[] linksToRemove;

    public SetTriggeringRequest() {
        this.requestHeader = null;
        this.subscriptionId = null;
        this.triggeringItemId = null;
        this.linksToAdd = null;
        this.linksToRemove = null;
    }

    public SetTriggeringRequest(RequestHeader requestHeader, UInteger subscriptionId, UInteger triggeringItemId, UInteger[] linksToAdd, UInteger[] linksToRemove) {
        this.requestHeader = requestHeader;
        this.subscriptionId = subscriptionId;
        this.triggeringItemId = triggeringItemId;
        this.linksToAdd = linksToAdd;
        this.linksToRemove = linksToRemove;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public UInteger getSubscriptionId() {
        return this.subscriptionId;
    }

    public UInteger getTriggeringItemId() {
        return this.triggeringItemId;
    }

    @Nullable
    public UInteger[] getLinksToAdd() {
        return this.linksToAdd;
    }

    @Nullable
    public UInteger[] getLinksToRemove() {
        return this.linksToRemove;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("RequestHeader", (Object)this.requestHeader).add("SubscriptionId", (Object)this.subscriptionId).add("TriggeringItemId", (Object)this.triggeringItemId).add("LinksToAdd", (Object)this.linksToAdd).add("LinksToRemove", (Object)this.linksToRemove).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<SetTriggeringRequest> {
        @Override
        public Class<SetTriggeringRequest> getType() {
            return SetTriggeringRequest.class;
        }

        @Override
        public SetTriggeringRequest decode(UaDecoder decoder) throws UaSerializationException {
            RequestHeader requestHeader = decoder.readBuiltinStruct("RequestHeader", RequestHeader.class);
            UInteger subscriptionId = decoder.readUInt32("SubscriptionId");
            UInteger triggeringItemId = decoder.readUInt32("TriggeringItemId");
            UInteger[] linksToAdd = decoder.readArray("LinksToAdd", decoder::readUInt32, UInteger.class);
            UInteger[] linksToRemove = decoder.readArray("LinksToRemove", decoder::readUInt32, UInteger.class);
            return new SetTriggeringRequest(requestHeader, subscriptionId, triggeringItemId, linksToAdd, linksToRemove);
        }

        @Override
        public void encode(SetTriggeringRequest value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStruct("RequestHeader", value.requestHeader, RequestHeader.class);
            encoder.writeUInt32("SubscriptionId", value.subscriptionId);
            encoder.writeUInt32("TriggeringItemId", value.triggeringItemId);
            encoder.writeArray("LinksToAdd", value.linksToAdd, encoder::writeUInt32);
            encoder.writeArray("LinksToRemove", value.linksToRemove, encoder::writeUInt32);
        }
    }
}

