/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

public class SignatureData
implements UaStructure {
    public static final NodeId TypeId = Identifiers.SignatureData;
    public static final NodeId BinaryEncodingId = Identifiers.SignatureData_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.SignatureData_Encoding_DefaultXml;
    protected final String algorithm;
    protected final ByteString signature;

    public SignatureData() {
        this.algorithm = null;
        this.signature = null;
    }

    public SignatureData(String algorithm, ByteString signature) {
        this.algorithm = algorithm;
        this.signature = signature;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public ByteString getSignature() {
        return this.signature;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Algorithm", (Object)this.algorithm).add("Signature", (Object)this.signature).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<SignatureData> {
        @Override
        public Class<SignatureData> getType() {
            return SignatureData.class;
        }

        @Override
        public SignatureData decode(UaDecoder decoder) throws UaSerializationException {
            String algorithm = decoder.readString("Algorithm");
            ByteString signature = decoder.readByteString("Signature");
            return new SignatureData(algorithm, signature);
        }

        @Override
        public void encode(SignatureData value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeString("Algorithm", value.algorithm);
            encoder.writeByteString("Signature", value.signature);
        }
    }
}

