/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.util;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.stack.core.UaException;

public class CertificateUtil {
    public static final int SUBJECT_ALT_NAME_URI = 6;
    public static final int SUBJECT_ALT_NAME_DNS_NAME = 2;
    public static final int SUBJECT_ALT_NAME_IP_ADDRESS = 7;

    public static X509Certificate decodeCertificate(byte[] certificateBytes) throws UaException {
        Preconditions.checkNotNull((Object)certificateBytes, (Object)"certificateBytes cannot be null");
        return CertificateUtil.decodeCertificate(new ByteArrayInputStream(certificateBytes));
    }

    public static X509Certificate decodeCertificate(InputStream inputStream) throws UaException {
        return CertificateUtil.decodeCertificates(inputStream).get(0);
    }

    public static List<X509Certificate> decodeCertificates(byte[] certificateBytes) throws UaException {
        return CertificateUtil.decodeCertificates(new ByteArrayInputStream(certificateBytes));
    }

    public static List<X509Certificate> decodeCertificates(InputStream inputStream) throws UaException {
        CertificateFactory factory;
        Preconditions.checkNotNull((Object)inputStream, (Object)"inputStream cannot be null");
        try {
            factory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new UaException(0x80020000L, (Throwable)e);
        }
        try {
            Collection<? extends Certificate> certificates = factory.generateCertificates(inputStream);
            return certificates.stream().map(X509Certificate.class::cast).collect(Collectors.toList());
        }
        catch (CertificateException e) {
            throw new UaException(2148663296L, (Throwable)e);
        }
    }

    public static Optional<Object> getSubjectAltNameField(X509Certificate certificate, int field) {
        try {
            Collection<List<?>> subjectAltNames = certificate.getSubjectAlternativeNames();
            if (subjectAltNames == null) {
                subjectAltNames = Collections.emptyList();
            }
            for (List<?> idAndValue : subjectAltNames) {
                if (idAndValue == null || idAndValue.size() != 2 || !idAndValue.get(0).equals(field)) continue;
                return Optional.ofNullable(idAndValue.get(1));
            }
            return Optional.empty();
        }
        catch (CertificateParsingException e) {
            return Optional.empty();
        }
    }
}

