/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.util;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.milo.opcua.stack.core.UaRuntimeException;

public class PShaUtil {
    public static byte[] createPSha1Key(byte[] secret, byte[] seed, int offset, int length) {
        return PShaUtil.createKey("HmacSHA1", secret, seed, offset, length);
    }

    public static byte[] createPSha256Key(byte[] secret, byte[] seed, int offset, int length) {
        return PShaUtil.createKey("HmacSHA256", secret, seed, offset, length);
    }

    private static byte[] createKey(String transformation, byte[] secret, byte[] seed, int offset, int length) {
        try {
            Mac mac = Mac.getInstance(transformation);
            byte[] tempBytes = PShaUtil.hash(transformation, secret, seed, mac, offset + length);
            byte[] key = new byte[length];
            System.arraycopy(tempBytes, offset, key, 0, key.length);
            return key;
        }
        catch (Exception e) {
            throw new UaRuntimeException(0x80020000L, (Throwable)e);
        }
    }

    private static byte[] hash(String transformation, byte[] secret, byte[] seed, Mac mac, int required) throws Exception {
        byte[] out = new byte[required];
        int offset = 0;
        byte[] a = seed;
        while (required > 0) {
            SecretKeySpec key = new SecretKeySpec(secret, transformation);
            mac.init(key);
            mac.update(a);
            a = mac.doFinal();
            mac.reset();
            mac.init(key);
            mac.update(a);
            mac.update(seed);
            byte[] tmp = mac.doFinal();
            int toCopy = PShaUtil.min(required, tmp.length);
            System.arraycopy(tmp, 0, out, offset, toCopy);
            offset += toCopy;
            required -= toCopy;
        }
        return out;
    }

    private static int min(int a, int b) {
        return a > b ? b : a;
    }
}

